<?php

namespace app\models\form;

use Yii;
use yii\base\Model;
use yii\db\ActiveRecord;
use app\models\User;


class ForgotWord extends Model
{
    public $secret_word;
	public $password;
	public $login;
	
	
	function __construct($login)
	{
		
		$this->login = $login;
		
	}


   
    public function rules()
    {
        return [
            
            [['secret_word','password'], 'required', 'message' => 'Необходимо заполнить это поле'],
            ['secret_word', 'string', 'length' => [3, 20]],
			['password', 'string', 'length' => [5, 40]],
			['secret_word', 'validateSecretWord'],
        ];
    }
    
    
    public function attributeLabels()
	 {
		 
		 return 
		 [
		  'secret_word' => 'Секретное слово',
		  'password' => 'Новый пароль',
		 ];
		 
	 }
	 
	  public function validateSecretWord($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $user = User :: findOne(['username' => $this->login, 'secret_word' => mb_strtolower($this->secret_word)]);

          
            if (!isset($user->id)) {
                $this->addError($attribute, 'Неверное секретное слово');
            }
                
        }
    }

  
 
}
