<?php

namespace app\models\active;

use app\models\User;
use Yii;
use yii\db\ActiveRecord;

class Battles_user extends ActiveRecord
{
    public static function inBattle($user_id)
    {
        return static::findOne(['user_id' => $user_id]) ?? null;
    }

    public static function joinToBattle($battle_id): bool
    {
        $user = User::findOne(Yii::$app->user->id);

        if (!empty($user) && empty(static::inBattle($user->id))) {
            $join = new Battles_user();
            $join->user_id = $user->id;
            $join->battle_id = $battle_id;
            $join->strike = $user->strike;
            $join->defend = $user->defend;
            $join->health = $user->health;
            $join->full_health = $user->health;
            $join->hits = 0;
            $join->damage = 0;
            $join->death = 0;
            $join->cooldown = 0;
            $join->save();
            return true;
        }
        return false;
    }

    public static function inBattleAndAlive($user_id)
    {
        return static::findOne(['user_id' => $user_id, 'death' => 0]) ?? null;
    }
}