<?php

namespace app\models\active;

use app\models\User;
use Yii;
use yii\db\ActiveRecord;
use yii\helpers\Html;

class Battles extends ActiveRecord
{
    public function startBattle($id): bool
    {
        $battle = static::findOne($id);

        if (empty($battle)) {
            return false;
        } else {
            //-- Чистим логи
            Battles_log::deleteAll(['battle_id' => $battle->id]);

            //-- Проверяем есть ли игроки в бою
            //-- Если нет => поражение
            $users = Battles_user::find()->where(['battle_id' => $battle->id])->count();

            if (empty($users)) {
                self::endBattleDefeat($battle->id);
                return true;
            } else {
                $battle->status = 2;
                $battle->save();

                $battle_log = new Battles_log();
                $battle_log->battle_id = $battle->id;
                $battle_log->text = 'Сражение началось';
                $battle_log->time = time();
                $battle_log->save();

                Battles_npc::reviveAllNpc($battle->id, $users);

                return true;
            }
        }
    }

    public function endBattle($id): bool
    {
        $battle = static::findOne($id);

        if (empty($battle)) {
            return false;
        } else {
            $battle->status = 1;
            $battle->time = time() + 3600;
            $battle->image = $battle->image == 24 ? 1 : $battle->image + 1;
            $battle->save();

            Battles_npc::removeAllNpc($battle->id);
            static::giveReward($battle->id);

            return true;
        }
    }

    public function endBattleDefeat($id): bool
    {
        $battle = static::findOne($id);

        if (empty($battle)) {
            return false;
        } else {
            $battle->status = 1;
            $battle->time = time() + 3600;
            $battle->image = $battle->image == 24 ? 1 : $battle->image + 1;
            $battle->save();

            Battles_npc::removeAllNpc($battle->id);
            Battles_user::deleteAll(['battle_id' => $battle->id]);

            $battle_log = new Battles_log();
            $battle_log->battle_id = $battle->id;
            $battle_log->text = 'Поражение!';
            $battle_log->time = time();
            $battle_log->save();

            return true;
        }
    }

    public function giveReward($id) {
        $battle = static::findOne($id);

        if (empty($battle)) {
            return false;
        } else {
            $users = Battles_user::find()->where(['battle_id' => $id])->all();
            $top_users = Battles_user::find()->where(['battle_id' => $id])->orderBy('damage desc')->limit(5)->all();

            if (!empty($top_users)) {
                Battles_top::deleteAll(['battle_id' => $battle->id]);
                foreach ($top_users as $top) {
                    $top_user = new Battles_top();
                    $top_user->battle_id = $battle->id;
                    $top_user->user_id = $top->user_id;
                    $top_user->hits = $top->hits;
                    $top_user->damage = $top->damage;
                    $top_user->ruby = $top->hits;
                    $top_user->cup = (int)($top->damage / 100);
                    $top_user->save();
                }
            }
            if (!empty($users)) {
                foreach ($users as $user) {
                    User::QuestSet(9, 1, null, $user->user_id);
                    $us = User::find()->where(['id' => $user->user_id])->one();

                    $battle_log = new Battles_log();
                    $battle_log->battle_id = $battle->id;
                    $battle_log->text = Html::encode($us->username) . ' получил <img src="/images/ruby.png" width="16"> '. $user->hits .', <img src="/images/cup.png" width="16"> '. (int)($user->damage / 100).'.';
                    $battle_log->time = time();
                    $battle_log->save();
                    $us->ruby = $us->ruby + $user->hits;
                    $us->rating_battles = $us->rating_battles + $user->rating;
                    $us->cup = $us->cup + (int)($user->damage / 100);
                    $us->save();
                    $user->delete();
                }
            } else {
                return false;
            }
        }
    }
}