<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;
use yii\web\IdentityInterface;
use yii\helpers\Html;
use app\models\active\Mybusiness;
use app\models\active\Business;
use app\models\active\Dialog;
use app\models\active\Achievements;
use app\models\active\Quest;
use app\models\active\Corp;

class User extends ActiveRecord implements IdentityInterface
{
    public static function tableName()
    {
        return 'users';
    }

	public static function answer($id = null)
	{

		$array =
		[
		'Какое прозвище было у вас в детстве?',
'В каком городе вы познакомились со своей второй половиной?',
'Как звали вашего лучшего друга детства?',
'На какой улице вы жили в третьем классе?',
'Какой месяц и год рождения вашего самого старшего родственника?',
'Какое отчество вашего среднего ребенка?',
'Какое отчество вашего самого старого родственника?',
'Какую школу вы посещали в шестом классе?',
'Какой у вас в детстве был номер телефона?',
'Какое имя и фамилия у вашего старшего двоюродного брата/сестры?',
'Как звали вашу первую плюшевую игрушку?',
'В каком месте встретились ваши родители?',
'Где вы в первый раз поцеловались?',
'Как звали мальчика/девочку которого вы поцеловали?',
'Как звали вашего учителя в третьем классе?',
'В каком городе живет ваш ближайший родственник?',
'Какой месяц и год рождения вашего старшего брата?',
'Какая девичья фамилия вашей бабушки?',
'В каком городе была ваша первая работа?',
'В каком месте была ваша свадебная церемония?',
'Как называлось учебное заведение в которое вы поступили, но не стали учиться?',
'Где вы были когда услышали о трагедии девятого сентября?',
		];

		return isset($id) ? $array[$id] : $array;

	}


	public static function BusinessPrice()
	{
		if(Yii::$app->user->identity->free_business >= 1) return 0;

		$mybsn = Mybusiness :: find()->select('price_default')->where(['user' => Yii::$app->user->id])->orderBy('id DESC')->one();
		if (empty($mybsn)) {
		    $price = 10;
        } else {
            $price = $mybsn['price_default']*10 ?? null;
        }

		return  \app\models\active\Action :: Week() == 2 ? $price/2 : $price;


	}

	public static function Notice($array = [])
	{

		Yii::$app->session->open();
		Yii::$app->session->set('notice', $array);

	}

	public static function Mail()
	{

		$mail = Dialog :: find()->where(['user' => Yii::$app->user->id])->andWhere(['_read'=>'1'])->count();

		if($mail > 0) return true;
	}

    public static function findIdentity($id)
    {
        return static::findOne($id);
    }

	public static function RandChest()
	{

		return mt_rand(1,96);

	}


	public static function findUser($id, $type = 1)
    {
        $user = static::findOne($id);

		if(!isset($user->id)) return 'Игрок удален';

		$setting = \app\models\active\Setting ::findOne(1);

		$online = $user->online > time()-$setting->online ? '<img src="/images/icons/online.png">' : null;

		$icon = '<span style="position: relative;display: inline-block;height: 30px;"><img src="/images/avatar/user/'.$user->sex.'/'.$user->avatar.'.png" class="avatar" width="30px" height="30px" style="vertical-align: middle;"> <span style="position: absolute;bottom: 0;right: 0;width: 12px;height: 9px;padding-right: 2px;padding-bottom: 5px;">'.$online.'</span></span> ';

		$role = [null, Html::tag('span', '[МД]', ['style' => 'color: green']),  Html::tag('span', '[АДМ]', ['style' => 'color: tomato'])];

		$user->username = $user->username ?? 'Гость'.$user->id;
		
		$color = $user->id == Yii::$app->user->id ? '#6bff33' : ($user->sex == 1 ? 'pink' : '#0087ff');

		$user->username = Html::tag('b',($user->vip >= time() ? Html::tag('span', Html::encode($user->username), ['class' => 'premium-nick']) : Html::encode($user->username)), ['style' => 'color: '.$color.';']);

		if($type == 1) return Html::a($icon.$user->username.' '.$role[$user->role], ['user/'.$id], ['style' => 'color:'.$color.';display: inline-block;height: 30px;']);

		return Html::tag('span', $icon.$user->username, ['style' => 'color:'.$color.';min-height: 30px;']);
	}



	public static function Rating($id = null, $type = null)
	{


		$users = static :: find()->orderBy($type.' desc')->all();
		$k = 1;

			foreach($users as $us):

			if($us['id'] == $id) return $k;

			$k++;
			endforeach;

	}


	public static function Block()
	{

	    if(Yii::$app->user->isGuest) return false;

	    $user = static::findOne(Yii::$app->user->id);

	    if($user->ban > time()) return Html::tag('div', 'Ваш аккаунт заблокирован! Осталось: '.\app\commands\Rounding :: Number($user->ban-time(), 0, 3), ['class' => 'feedback']);
	}



	public static function Income($id = null, $type = null)
	{

		$user = static :: findOne($id ?? Yii::$app->user->id);

		$business = Mybusiness :: find()->where(['user' => $user->id])->sum('income') ?? '0';

		if($type == 1) return $business;

		$business = $business*$user->bonus;
		$business = $business*$user->bonus_chest;

		if($user->corp > 0){

		    $corp = Corp :: findOne($user->corp);

		    if(isset($corp->id)){

		        if($corp->statue > 0) $business = $business+$business*($corp->statue*0.2);

		        if($corp->card > time()) $business = $business*2;

		    }

		}

		$income = $user->angel > 0 ? $business * $user->angel/100 : $business;

		$income = $user->status > 0 ? $income * ($user->status+1) : $income;

		$income = \app\models\active\Action :: Week() == 1 ? $income*2 : $income;

		return round($income);

	}





	public static function Visa()
	{

		return (object)Yii::$app->params['UserStatus'][Yii::$app->user->identity->status] ?? null;

	}

  public static function VisaUs($id)
  {

    $array = ['Нету','Оформлена','Гражданин','Вид на Жительство'];

    return $array[$id];

  }




	public static function BusinessCount($id = null)
	{

		$user = static :: findOne($id ?? Yii::$app->user->id);

		$business = Mybusiness :: find()->where(['user' => $user->id])->andWhere(['>=','level','1'])->count() ?? '0';



		return $business;

	}


	public static function BusinessCountIncome($id = null)
	{

		$user = static :: findOne($id ?? Yii::$app->user->id);

		$business = Mybusiness :: find()->where(['user' => $user->id])->andWhere(['>','level','1'])->count() ?? '0';



		return $business;

	}




    public static function Online()
	{

		$user = static :: findOne(Yii::$app->user->id);

		$user->online = time();
		$user->save();



	}




    public static function findIdentityByAccessToken($token, $type = null)
    {
        return static::findOne(['access_token' => $token]);
    }


    public function getId()
    {
        return $this->id;
    }


    public function getPassword()
    {
        return $this->password;
    }


    public function getAuthKey()
    {
        return $this->auth_key;
    }


    public function validateAuthKey($authKey)
    {
        return $this->getAuthKey() === $authKey;
    }

      public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            if ($this->isNewRecord) {
                $this->auth_key = \Yii::$app->security->generateRandomString();
            }
            return true;
        }
        return false;
    }


     public function validatePassword($password)
    {
        return Yii::$app->security->validatePassword($password, $this->password_hash);
    }


    public function setPassword($password)
    {
        $this->password = Yii::$app->security->generatePasswordHash($password);
    }


	public static function OnlineCount()
	{
		$setting = \app\models\active\Setting ::findOne(1);
		return static :: find()->where(['>','online',time()-$setting->online])->count();

	}

	public static function ReferalCount()
	{

		return static :: find()->where(['ref' => Yii::$app->user->id])->count();

	}


	public static function Achievements($user_id, $id)
	{

		$user = static :: findOne($user_id);

		if(!isset($user->id)) return false;

		$ach  = Achievements :: findOne(['type' => $id, 'user' => $user->id]);

		if(!isset($ach->id)) return 0;

		return $ach->count;

	}

	public static function AchievementsSet($user_id, $id, $value)
	{

		$user = static :: findOne($user_id);

		if(!isset($user->id)) return false;

		$ach  = Achievements :: findOne(['type' => $id, 'user' => $user->id]);

		if(!isset($ach->id))
		{

			$ach = new Achievements();
			$ach->user = $user->id;
			$ach->type = $id;
			$ach->count = $value;
			$ach->save();


		}
			else

		{

			$ach->count = $value;
			$ach->save();


		}



	}


	public static function AchievementsDone($user_id, $id,$value)
	{

		$user = static :: findOne($user_id);

		if(!isset($user->id)) return false;

		if($user->id != Yii::$app->user->id) false;

		$ach  = Achievements :: findOne(['type' => $id, 'user' => $user->id]);

		if(!isset($ach->id)) return false;

		if($ach->count >= $value && $ach->reward == 0) return true;

    }
    
    
    
    public static function AchievementsDoneUs($user_id, $id)
	{

		$user = static :: findOne($user_id);

		if(!isset($user->id)) return false;

		if($user->id != Yii::$app->user->id) false;

		$ach  = Achievements :: findOne(['type' => $id, 'user' => $user->id]);

		if(!isset($ach->id)) return false;

		if($ach->reward == 1) return true;

    }


	public static function AchievementsCount()
	{

	    $user = User :: findOne(Yii::$app->user->id);

	    if(!isset($user->id)) return false;

	    $all = Achievements :: find()->where(['user' => $user->id,'reward' => '0']);

	    $array = [
	        1 => 25000,
            2 => 1000,
            3 => 15,
            4 => 50,
            5 => 3,
            6 => 15000,
            7 => 12,
            8 => 500000,
            9 => 50,
            10 => 10,
            11 => 10,
            12 => 3000
        ];


	        foreach($all->all() as $ach):

	            if($ach['count'] >= $array[$ach['type']]) return '+';

	       endforeach;

	   return false;

	}


	public static function Quest($id)
	{

		$user = static :: findOne(Yii::$app->user->id);

		if(!isset($user->id)) return false;

		$quest  = Quest :: findOne(['type' => $id, 'user' => $user->id]);

		if(!isset($quest->id)) return 0;

		return $quest->count;

	}


	public static function QuestDone($id,$value)
	{

		$user = static :: findOne(Yii::$app->user->id);

		if(!isset($user->id)) return false;

		if($user->id != Yii::$app->user->id) false;

		$quest  = Quest :: findOne(['type' => $id, 'user' => $user->id, 'price' => '0']);

		if(!isset($quest->id)) return false;

		if($quest->count >= $value && $quest->price == 0) return true;

    }


    public static function QuestSet($id, $value, $type = null, $user_id = null)
	{

        $user = static:: findOne($user_id ?? Yii::$app->user->id);

		if(!isset($user->id)) return false;

		$quest  = Quest :: findOne(['type' => $id, 'user' => $user->id]);



		if(!isset($quest->id))
		{

			$quest = new Quest();
			$quest->user = $user->id;
			$quest->type = $id;
			$quest->count = $value;
			$quest->time = strtotime(date('d.m.Y',time()+86400));
			$quest->save();


		}
			else

		{


			$quest->count = isset($type) ? $value : $quest->count + $value;
			$quest->save();


		}



	}

	public static function QuestCount()
	{

	    $user = User :: findOne(Yii::$app->user->id);

	    if(!isset($user->id)) return false;

	    $all = Quest :: find()->where(['user' => $user->id,'price' => '0']);

	    $array = [1 => 50, 2 => 3, 3 => 1, 4 => 500, 5 => 1, 6 => 20, 7 => 1800, 8 => 5, 9 => 1];


	        foreach($all->all() as $quest):

	            if($quest['count'] >= $array[$quest['type']]) return true;

	       endforeach;

	   return false;

	}

	public static function QuestDonePrice($quest_id)
	{

	    $quest = Quest :: findOne(['user' => Yii::$app->user->id, 'type' => $quest_id, 'price' => '1']);

	    if(isset($quest->id)) return true;

	}
	
	
	public static function QuestsDoneUs()
	{


		$quest  = Quest :: find()->where(['price' => '1', 'user' => Yii::$app->user->id]);

		return $quest->count();

    }

}
