<?php

namespace app\controllers;

use app\models\active\Avatar;
use DateTime;
use Yii;
use yii\filters\AccessControl;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use app\models\User;
use app\models\active\{Battles,
    Battles_log,
    Battles_npc,
    Battles_top,
    Battles_user,
    Business,
    Dialog,
    Journal,
    Mail,
    Market,
    Mybusiness,
    Chat,
    Corpinvite,
    Forum_topic,
    Smile,
    Corp,
    Giftuser,
    Gift};


class SiteController extends Controller
{

    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['get'],
                ],
            ],
        ];
    }


    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }


    public function actionIndex($hide = null, $dump = null)
    {
        if (Yii::$app->user->isGuest) return $this->render('index');

        $user = User:: findOne(Yii::$app->user->id);

        $mybusiness = Mybusiness:: find()->where(['user' => $user->id])->orderBy('business DESC')->all();

        $invite = Corpinvite:: find()->where(['user' => $user->id]);

        $query = Mybusiness:: find()->where(['user' => $user->id]);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);


        $topic = Forum_topic:: findOne($user->news_read);

        if (isset($hide)) {
            if ($hide == 'forum') {
                $user->forum_reply = 0;
                $user->save();
                return $this->goHome();
            }

            if ($hide == 'chat') {
                $user->chat_reply = 0;
                $user->save();
                return $this->goHome();

            }


            if ($hide == 'gift') {
                $giftus = Giftuser:: find()->select('id')->where(['user' => $user->id, 'view' => '1'])->orderBy('id desc')->one();
                $giftus = Giftuser:: findOne($giftus['id']);
                $giftus->view = 0;
                $giftus->save();
                return $this->goHome();

            }

        }

        $giftus = Giftuser:: find()->where(['user' => $user->id, 'view' => '1'])->orderBy('id desc')->one();

        $count_b = (int)Mybusiness::find()->where(['user' => $user->id])->count();
        $cost_b = $count_b * 100;
        $count_full_b = (int)Mybusiness::find()->where(['user' => $user->id, 'level' => 10000])->count();
        if (!empty($count_full_b)) {
            $cost_b = $cost_b + (100 * $count_full_b);
        }

        if (!empty($dump)) {
            if ($cost_b < 1) {
                User:: Notice(['title' => 'Вы не получаете доход', 'status' => 'error']);
                return $this->redirect('/user/' . (int)$id);
            } elseif ($count_b < 15) {
                User:: Notice(['title' => 'Доступно после наличия 15 бизнесов. У вас ' . $count_b . '.', 'status' => 'error']);
                return $this->redirect('/user/' . (int)$id);
            } else {
                $business = Mybusiness:: find()->where(['user' => $user->id])->one();

                if (!empty($business)) {
                    if (User:: Achievements($user->id, 9) < 50) {
                        User:: AchievementsSet($user->id, 9, User:: Achievements($user->id, 9) + $count_b);
                    }
                    if (User:: Achievements($user->id, 1) < 25000) {
                        User:: AchievementsSet($user->id, 1, User:: Achievements($user->id, 1) + $cost_b);
                    }
                    $user->cup = $user->cup + $cost_b;
                    $user->dump_business = $user->dump_business + 1;
                    $user->save();
                    Mybusiness::deleteAll(['user' => $user->id]);

                    if (User:: Achievements($user->id, 11) < 10) {
                        User:: AchievementsSet($user->id, 11, 0);
                    }

                    User:: Notice(['title' => 'Все бизнесы успешно сброшены', 'status' => 'success']);
                    return $this->redirect('/user/' . (int)$id);
                } else {
                    User:: Notice(['title' => 'У вас нет активных бизнесов', 'status' => 'error']);
                    return $this->redirect('/user/' . (int)$id);
                }
            }
        } else {
            $in_battle = Battles_user::inBattleAndAlive(Yii::$app->user->id);
            if (!empty($in_battle)) {
                $battle = Battles::findOne($in_battle->battle_id);

                if ($battle->time <= time() && $battle->time > (time() - 3600) && $battle->status == 2) {
                    return $this->redirect('/battle');
                }
            }

            $coming_battle = Battles::find()
                ->where(['>', 'time', time()])
                ->andWhere(['<', 'time', time() + 300])
                ->one();

            //-- Unread shop log
            $journal = Journal::find()
                ->where(['user_id' => $user->id, 'read' => '1'])
                ->one();
            return $this->render('game', [
                'user' => $user,
                'mybusiness' => $mybusiness,
                'invite' => $invite,
                'pagination' => $pagination,
                'giftus' => $giftus,
                'page' => $pagination->getPage() + 1,
                'topic' => $topic,
                'count_b' => $count_b,
                'cost_b' => $cost_b,
                'journal' => $journal,
                'coming_battle' => $coming_battle
            ]);
        }
    }

    public function actionStart($ref_id = 0, $sex = null)
    {

        if (!Yii::$app->user->isGuest) return $this->goHome();

        $ref = User:: findOne($ref_id);

        if (!isset($sex)) {

            return $this->render('start');


        }

        if (!in_array($sex, range(0, 1))) return $this->redirect('/start');

        $user = new User();
        $user->online = time();
        $user->ref = $ref->id ?? 0;
        $user->sex = $sex;
        $user->ruby = 100;
        $user->save();

        if ($user->id == 1) {

            $user->role = 2;
            $user->save();
        }

        if ($user->id == 2) {

            $user->role = 1;
            $user->save();
        }

        if (!empty($user->ref)) {
            if (User:: Achievements($user->id, 10) < 10) {
                User:: AchievementsSet($user->ref, 10, User:: Achievements($user->ref, 10) + 1);
            }
        }

        Yii::$app->user->login($user, 3600 * 24);

        $bsn = Business:: find()->select('id')->orderBy('id')->one();

        $newbsn = new Mybusiness();
        $newbsn->user = $user->id;
        $newbsn->business = $bsn['id'];
        $newbsn->income = 1;
        $newbsn->price_default = 1;
        $newbsn->save();


        return $this->goHome();


    }


    public function actionLogin()
    {

        if (!Yii::$app->user->isGuest) return $this->goHome();

        $model = new \app\models\form\Login();

        if ($model->load(Yii::$app->request->post()) && $model->login()) {

            return $this->goHome();

        }

        return $this->render('login',
            [
                'model' => $model
            ]
        );


    }


    public function actionChat($type = null)
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $query = Chat:: find();

        $user = User:: findOne(Yii::$app->user->id);

        if ($type == 'corp' && $user->corp == 0) return $this->goBack();

        if ($type == 'corp') $query->where(['corp' => $user->corp]);


        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);


        return $this->render('chat',

            [
                'pagination' => $pagination,
                'emoji' => Chat:: Emoji(),
                'emojihead' => Chat:: EmojiHead(),
                'type' => $type,
            ]
        );


    }


    public function actionLogout()
    {
        Yii::$app->getResponse()->getCookies()->get('_identity');
        Yii::$app->user->logout();
        Yii::$app->getResponse()->getCookies()->remove('_identity');
        return $this->goHome();
    }



    public function actionTourney()
    {

        $query = User:: find()->where(['>', 'cup', '0']);


        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('cup desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        $tourney = \app\models\active\Tourney:: findOne(1);

        $count = ($pagination->getPage() + 1) > 1 ? ($pagination->getPage() + 1) * 10 - 9 : 1;


        return $this->render('tourney',
            [
                'count_query' => $query->count(),
                'all' => $all,
                'count' => $count,
                'tourney' => $tourney,
                'pagination' => $pagination,
            ]

        );


    }


    public function actionTourneyCorp()
    {

        $query = Corp:: find();


        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('cup desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        $tourney = \app\models\active\Tourney:: findOne(2);

        $count = ($pagination->getPage() + 1) > 1 ? ($pagination->getPage() + 1) * 10 - 9 : 1;


        return $this->render('tourney_corp',
            [

                'all' => $all,
                'count' => $count,
                'tourney' => $tourney,
                'pagination' => $pagination,
            ]

        );


    }

    public function actionForgot($username = null)
    {

        if (!Yii::$app->user->isGuest) return $this->goHome();


        if (!isset($username)) {

            $model = new \app\models\form\Forgot();

            if ($model->load(Yii::$app->request->post()) && $model->validate()) {


                $user = User:: findOne(['username' => $model->username]);


                return $this->redirect('/forgot?username=' . $user->username);

            }

            return $this->render('forgot', ['model' => $model]);


        } else {

            $user = User:: findOne(['username' => $username]);

            if (!isset($user->id)) return $this->goHome();

            $model = new \app\models\form\ForgotWord($user->username);

            if ($model->load(Yii::$app->request->post()) && $model->validate()) {


                $user->password = Yii::$app->getSecurity()->generatePasswordHash($model->password);
                $user->save();

                Yii::$app->user->login($user, 3600 * 24 * 30);

                User:: Notice(['title' => 'Пароль успешно изменен', 'status' => 'success']);
                return $this->goHome();
            }

            return $this->render('forgot_word', ['model' => $model, 'user' => $user]);

        }
    }

    /**
     * Premium shop action;
     * @param null $action
     * @return Response|string
     * @author OlegKulaga(Medan)
     */
    public function actionPremiumShop($action = null)
    {
        if (Yii::$app->user->isGuest) return $this->goHome();

        if ($action == 'avatar') {
            $avatars = Avatar:: find()->where(['sex' => Yii::$app->user->identity->sex])->all();
            return $this->render('premium-shop', [
                'action' => 'avatar',
                'avatars' => $avatars
            ]);
        } elseif ($action == 'premium') {
            $buy = Yii::$app->request->get('buy');
            $user = User::findOne(Yii::$app->user->id);

            $current = $user->vip < time() ? time() : $user->vip;
            $duration = $current + (86400 * $buy);
            $cost = [
                1 => 100,
                3 => 300,
                7 => 700
            ];

            if (isset($buy)) {
                if (!in_array($buy, array_keys($cost))) {
                    User::Notice(['title' => 'Недопустимое значение.', 'status' => 'error']);
                    return $this->redirect('/premium-shop?action=premium');
                } elseif ($user->ruby < $cost[$buy]) {
                    User::Notice(['title' => 'Недостаточно рубинов.', 'status' => 'error']);
                    return $this->redirect('/premium-shop?action=premium');
                } else {
                    $user->vip = $duration;
                    $user->ruby = $user->ruby - $cost[$buy];
                    $user->save();

                    User:: Notice(['title' => 'Вы успешно преобрели премиум аккаунт.', 'status' => 'success']);
                    return $this->redirect('/premium-shop?action=premium');
                }
            }

            return $this->render('premium-shop', [
                'action' => 'premium',
                'cost' => $cost
            ]);
        } else {
            return $this->render('premium-shop', [
                'action' => null
            ]);
        }
    }

    /**
     * Premium shop action;
     * @param null $action
     * @return Response|string
     * @author OlegKulaga(Medan)
     */
    public function actionMarket($action = null)
    {
        if (Yii::$app->user->isGuest) return $this->goHome();
        if ($action == 'newLot') {
            $model = new \app\models\form\MarketAddLot();

            if ($model->load(Yii::$app->request->post()) && $model->validate()) {
                $user = User:: findOne(Yii::$app->user->id);

                if ($user->_key < $model->keys) {
                    User:: Notice(['status' => 'error', 'title' => 'Недостаточно ключей']);
                    return $this->redirect('/market?action=newLot');
                } elseif ($user->ruby < 100) {
                    User:: Notice(['status' => 'error', 'title' => 'Недостаточно рубинов']);
                    return $this->redirect('/market?action=myLots');
                } else {
                    $user->_key = $user->_key - $model->keys;
                    $user->ruby = $user->ruby - 100;
                    $user->save();

                    $market = new Market();
                    $market->user_id = $user->id;
                    $market->keys = $model->keys;
                    $market->cost = $model->cost;
                    $market->time = time() + 86400;
                    $market->save();

                    User:: Notice(['status' => 'success', 'title' => 'Лот успешно добавлен']);
                    return $this->redirect('/market?action=myLots');
                }
            }

            return $this->render('market', [
                'action' => 'newLot',
                'model' => $model
            ]);
        } elseif ($action == 'myLots') {
            $remove = (int)Yii::$app->request->get('remove');
            $extend = (int)Yii::$app->request->get('extend');

            if (isset($remove) && !empty($remove) && is_numeric($remove)) {
                $user = User::findOne(Yii::$app->user->id);
                $lot = Market::findOne(['user_id' => $user->id, 'id' => $remove]);

                if (empty($lot)) {
                    User:: Notice(['status' => 'error', 'title' => 'Лот не найден']);
                    return $this->redirect('/market?action=myLots');
                } else {
                    $user->_key = $user->_key + $lot->keys;
                    $user->save();

                    $lot->delete();

                    User:: Notice(['status' => 'success', 'title' => 'Лот успешно удален']);
                    return $this->redirect('/market?action=myLots');
                }
            } elseif (isset($extend) && !empty($extend) && is_numeric($extend)) {
                $user = User::findOne(Yii::$app->user->id);
                $lot = Market::findOne(['user_id' => $user->id, 'id' => $extend]);

                if (empty($lot)) {
                    User:: Notice(['status' => 'error', 'title' => 'Лот не найден']);
                    return $this->redirect('/market?action=myLots');
                } elseif ($user->ruby < 100) {
                    User:: Notice(['status' => 'error', 'title' => 'Недостаточно рубинов']);
                    return $this->redirect('/market?action=myLots');
                } else {
                    $user->ruby = $user->ruby - 100;
                    $user->save();

                    $lot->time = $lot->time < time() ? time() + 86400 : $lot->time + 86400;
                    $lot->save();

                    User:: Notice(['status' => 'success', 'title' => 'Лот успешно продлен']);
                    return $this->redirect('/market?action=myLots');
                }
            } else {
                $user = User::findOne(Yii::$app->user->id);
                $query = Market::find()->where(['user_id' => $user->id]);

                $pagination = new Pagination([
                    'defaultPageSize' => 10,
                    'totalCount' => $query->count(),
                    //'params' => array_merge($_GET, ['action' => $action])
                ]);

                $lots = $query->orderBy('cost asc')
                    ->offset($pagination->offset)
                    ->limit($pagination->limit)
                    ->all();

                return $this->render('market', [
                    'action' => 'myLots',
                    'lots' => $lots,
                    'pagination' => $pagination
                ]);
            }
        } else {
            $buy = (int)Yii::$app->request->get('buy');
            $user = User::findOne(Yii::$app->user->id);

            if (isset($buy) && !empty($buy) && is_numeric($buy)) {
                $lot = Market::findOne(['id' => $buy]);

                if (empty($lot)) {
                    User:: Notice(['status' => 'error', 'title' => 'Лот не найден']);
                    return $this->redirect('/market');
                } elseif ($user->id == $lot->user_id) {
                    User:: Notice(['status' => 'error', 'title' => 'Лот не найден']);
                    return $this->redirect('/market');
                } elseif ($user->ruby < $lot->cost) {
                    User:: Notice(['status' => 'error', 'title' => 'Недостаточно рубинов']);
                    return $this->redirect('/market');
                } elseif ($lot->time < time()) {
                    User:: Notice(['status' => 'error', 'title' => 'Лот не найден']);
                    return $this->redirect('/market');
                } else {
                    $seller = User::findOne($lot->user_id);
                    if (!empty($seller)) {
                        $seller->ruby = $seller->ruby + $lot->cost;
                        $seller->save();

                        $journal = new Journal();
                        $journal->user_id = $lot->user_id;
                        $journal->text = User:: findUser($user->id) . ' купил ваш лот за +<img src="/images/ruby.png" alt="r" width="18" height="18">' . $lot->cost;
                        $journal->read = '1';
                        $journal->time = time();
                        $journal->save();
                    }

                    $user->_key = $user->_key + $lot->keys;
                    $user->ruby = $user->ruby - $lot->cost;
                    $user->save();

                    $lot->delete();

                    User:: Notice(['status' => 'success', 'title' => 'Лот успешно приобретен']);
                    return $this->redirect('/market');
                }
            }
            $query = Market::find()->where(['>', 'time', time()]);

            $pagination = new Pagination([
                'defaultPageSize' => 10,
                'totalCount' => $query->count()
            ]);

            $lots = $query->orderBy('cost asc')
                ->offset($pagination->offset)
                ->limit($pagination->limit)
                ->all();

            //-- Unread shop log
            $journal = Journal::find()
                ->where(['user_id' => $user->id, 'read' => '1'])
                ->one();

            return $this->render('market', [
                'action' => null,
                'lots' => $lots,
                'journal' => $journal,
                'pagination' => $pagination
            ]);
        }
    }

    /**
     * Крупнокалиберный модуль на снаряжения
     * Все сражения
     * status {1 - Не начато, 0 - Закончено, 2 - Начато}
     * @author OlegKulaga(Medan)
     */
    public function actionBattles(): Response
    {
        if (Yii::$app->user->isGuest) return $this->goHome();
        return $this->redirect('/battle/lobby/1');
        //echo time() + 60;
        /*
        $battles = Battles::find()
            ->orderBy('time')
            ->all();
        /*
        if (Yii::$app->user->id == 4) {
            foreach ($battles as $battle) {
                $battle->time = time() + (900 * $battle->id);
                $battle->save();
            }
        }
        */

        //return $this->render('battles');
    }

    public function actionBattleLobby($id)
    {
        if (Yii::$app->user->isGuest) return $this->goHome();

        $battle = Battles::find()->where(['id' => $id])->one();
        $in_users = Battles_user::find()->where(['battle_id' => $battle->id])->count();

        if (empty($battle)) {
            User:: Notice(['status' => 'error', 'title' => 'Лобби не найдено']);
            return $this->redirect('/battles');
        } else {
            if ($battle->time < time() && $battle->time > (time() - 3600)) {
                if ($battle->status != '2') {
                    (new Battles)->startBattle($battle->id);
                    return $this->redirect('/battle/lobby/' . $battle->id);
                }
            }
            if ($battle->status == 2) {
                $leave_count = Battles_user::find()->where(['battle_id' => $battle->id, 'death' => 0])->count();
                if (empty($leave_count)) {
                    (new Battles)->endBattleDefeat($battle->id);
                }
            }

            $battle_top = Battles_top::find()->where(['battle_id' => $id])->orderBy('damage desc')->limit(5)->all();
            $battle_log = Battles_log::find()
                ->where(['battle_id' => $battle->id])
                ->orderBy('time desc')
                ->limit(50)
                ->all();
            return $this->render('battle-lobby', [
                'battle' => $battle,
                'in_users' => $in_users,
                'battle_top' => $battle_top,
                'battle_log' => $battle_log
            ]);
        }
    }

    public function actionBattleJoin($id): Response
    {
        if (Yii::$app->user->isGuest) return $this->goHome();

        $battle = Battles::find()->where(['id' => $id])->one();

        if (empty($battle)) {
            User:: Notice(['status' => 'error', 'title' => 'Лобби не найдено']);
            return $this->redirect('/battles');
        } else {
            if ($battle->time < time() && $battle->time >= (time() - 3600)) {
                User:: Notice(['status' => 'error', 'title' => 'Сражение уже начато']);
            } else {
                if (Battles_user::joinToBattle($battle->id) == true) {
                    User:: Notice(['status' => 'success', 'title' => 'Осталось дождаться начала сражения']);
                } else {
                    User:: Notice(['status' => 'error', 'title' => 'Что-то пошло не так']);
                }
            }
            return $this->redirect('/battle/lobby/' . $battle->id);
        }
    }

    /**
     * Собственно само сражение
     */
    public function actionBattle($attack = null)
    {
        if (Yii::$app->user->isGuest) return $this->goHome();

        $in_battle = Battles_user::inBattle(Yii::$app->user->id);

        if (empty($in_battle)) {
            User:: Notice(['status' => 'error', 'title' => 'Сражение недоступно']);
            return $this->redirect('/battles');
        } else {
            $battle = Battles::find()->where(['id' => $in_battle->battle_id])->one();

            if (empty($battle)) {
                $in_battle->delete();
                User:: Notice(['status' => 'error', 'title' => 'Сражение недоступно']);
                return $this->redirect('/battles');
            } elseif ($battle->status != 2) {
                User:: Notice(['status' => 'error', 'title' => 'Сражение еще не начато']);
                return $this->redirect('/battles');
            }
            else {
                $user = User::findOne(Yii::$app->user->id);
                $leave_count = Battles_user::find()->where(['battle_id' => $battle->id, 'death' => 0])->count();
                $npc = Battles_npc::find()
                    ->where(['battle_id' => $battle->id])
                    ->andWhere(['type' => 'npc'])
                    ->andWhere(['>', 'health', 0])
                    ->all();
                $npc_count = count($npc);

                $boss = Battles_npc::find()
                    ->where(['battle_id' => $battle->id])
                    ->andWhere(['type' => 'boss'])
                    ->andWhere(['>', 'health', 0])
                    ->all();
                $boss_count = count($boss);

                $battle_log = Battles_log::find()
                    ->where(['battle_id' => $battle->id])
                    ->orderBy('time desc')
                    ->limit(20)
                    ->all();

                $enemy = !empty($in_battle->enemy) ? $in_battle->enemy : null;
                if (!empty($enemy)) {
                    $enemy = Battles_npc::find()->where(['id' => $in_battle->enemy, 'battle_id' => $battle->id])
                        ->andWhere(['>', 'health', 0])->one();
                    if (empty($enemy)) {
                        $in_battle->enemy = 0;
                        $in_battle->save();
                    }
                }

                //-- Если закончились противники вручную заканчиваем сражение
                if ($battle->time < (time() - 3600) || empty($leave_count)) {
                    (new Battles)->endBattleDefeat($battle->id);
                }
                if (empty($npc_count) && empty($boss_count)) {
                    (new Battles)->endBattle($battle->id);
                    return $this->redirect('/battle/lobby/' . $battle->id);
                }

                if (!empty($attack) && empty($in_battle->death)) {
                    if ($attack != 'random' && $attack != 'enemy') {
                        return $this->redirect('/battle');
                    } else {
                        if (empty($enemy)) {
                            if (!empty($npc_count)) {
                                $enemy = Battles_npc::find()->where(['battle_id' => $battle->id])
                                    ->andWhere(['type' => 'npc'])
                                    ->andWhere(['>', 'health', 0])
                                    ->one();
                                $in_battle->enemy = $enemy->id;
                                $in_battle->save();
                            } elseif (!empty($boss_count)) {
                                $enemy = Battles_npc::find()->where(['battle_id' => $battle->id])
                                    ->andWhere(['type' => 'boss'])
                                    ->andWhere(['>', 'health', 0])
                                    ->one();
                                $in_battle->enemy = $enemy->id;
                                $in_battle->save();
                            } else {
                                User:: Notice(['status' => 'error', 'title' => 'На поле сражения закончились противники. Похоже что победа за нами.']);
                                return $this->redirect('/battle');
                            }
                        }

                        if (!empty($npc_count) || !empty($boss_count)) {
                            if ($in_battle->cooldown < time()) {
                                $user_attack = (int)rand($in_battle->strike / 2, $in_battle->strike);
                                $user_attack = $user_attack > $enemy->health ? $enemy->health : $user_attack;
                                $battle_log = new Battles_log();
                                $battle_log->battle_id = $battle->id;
                                if (mt_rand(1, 100) <= 30) {
                                    $defended = mt_rand($enemy->defend / 2, $enemy->defend);
                                    $defended = $defended > $user_attack ? $user_attack : $defended;
                                    $user_attack = $user_attack - $defended;
                                    $user_attack = $user_attack <= 0 ? 1 : $user_attack;

                                    if ($user_attack == $enemy->health) {
                                        $battle_log->text = $enemy->name . ' попытался защититься, но был уничтожен.';
                                    } else {
                                        $battle_log->text = $enemy->name . ' частично защитился от удара и потерял ' . $user_attack . ' здоровья. <span style="color: cornflowerblue;">(поглощено '. $defended .' урона).</span>';
                                    }
                                } else {
                                    if ($user_attack == $enemy->health) {
                                        $battle_log->text = $enemy->name . ' уничтожен.';
                                    } else {
                                        $battle_log->text = $enemy->name . ' не смог отразить атаку и потерял ' . $user_attack . ' здоровья.';
                                    }
                                }

                                $battle_log->time = time();
                                $battle_log->save();

                                $enemy->health = $enemy->health - $user_attack;
                                $enemy->save();
				
						
					  include ('league_s.php');
			
                                $in_battle->hits = $in_battle->hits + ($league[$type_league]['ruby']);
                                $in_battle->rating = $in_battle->rating + 1;
                                $in_battle->damage = $in_battle->damage + $user_attack;
                                $in_battle->cooldown = time() + 3;
                                $in_battle->save();
                            } else {
                                $battle_log = new Battles_log();
                                $battle_log->battle_id = $battle->id;
                                $battle_log->text = '<span class="tgray">' . Html::encode($user->username) . ' промахнулся.</span> ';
                                $battle_log->time = time();
                                $battle_log->save();
                                //User:: Notice(['status' => 'error', 'title' => 'Промах.']);
                            }

                            if (mt_rand(1, 100) <= 40) {
                                $npc_attack = (int)rand($enemy->strike / 2, $enemy->strike);
                                $npc_attack = $npc_attack > $in_battle->health ? $in_battle->health : $npc_attack;
                                $battle_log = new Battles_log();
                                $battle_log->battle_id = $battle->id;

                                if (mt_rand(1, 100) <= 30) {
                                    $us_defended = mt_rand($in_battle->defend / 2, $in_battle->defend);
                                    $us_defended = $us_defended > $npc_attack ? $npc_attack : $us_defended;
                                    $npc_attack = $npc_attack - $us_defended;
                                    $npc_attack = $npc_attack <= 0 ? 1 : $npc_attack;

                                    if ($npc_attack == $in_battle->health) {
                                        $battle_log->text = Html::encode($user->username) . ' попытался защитится, но был убит.';
                                        $battle_log->time = time();
                                        $battle_log->save();

                                        $in_battle->health = 0;
                                        $in_battle->death = 1;
                                    } else {
                                        $battle_log->text = $enemy->name . ' нанёс ' . Html::encode($user->username) . ' ' . $npc_attack . ' урона. <span style="color: cornflowerblue;">(поглощено '. $us_defended .' урона).</span>';
                                        $battle_log->time = time();
                                        $battle_log->save();

                                        $in_battle->health = $in_battle->health - $npc_attack;
                                    }
                                } else {
                                    if ($npc_attack == $in_battle->health) {
                                        $battle_log->text = $enemy->name . ' убил ' . Html::encode($user->username) . '.';
                                        $battle_log->time = time();
                                        $battle_log->save();

                                        $in_battle->health = 0;
                                        $in_battle->death = 1;
                                    } else {
                                        $battle_log->text = $enemy->name . ' нанёс ' . Html::encode($user->username) . ' ' . $npc_attack . ' урона.';
                                        $battle_log->time = time();
                                        $battle_log->save();

                                        $in_battle->health = $in_battle->health - $npc_attack;
                                    }
                                }


                                $in_battle->save();
                            }
                            return $this->redirect('/battle');
                        }
                    }
                }

                return $this->render('battle', [
                    'battle' => $battle,
                    'in_battle' => $in_battle,
                    'npc_count' => $npc_count,
                    'boss_count' => $boss_count,
                    'enemy' => $enemy,
                    'battle_log' => $battle_log
                ]);
            }
        }
    }

    /**
     * Запуск сражений по крону
     * @author Oleg Kulaga (Medan)
     */
    public function actionCron()
    {
       	$battles = Battles::find()->all();
	
	foreach ($battles as $battle) {
		if ($battle->time < time()) {
			if ($battle->status != 2) {
				(new Battles)->startBattle($battle->id);
			}
		}
		elseif ($battle->time <= time() && $battle->time >= (time() - 3600)) {
			if ($battle->status ==  2) {
				(new Battles)->endBattle($battle->id);
			}
		}
	}
    }
}