<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use app\models\LoginForm;
use app\models\User;
use yii\data\Pagination;
use yii\helpers\Html;
use app\models\active\Forum_razdel;
use app\models\active\Forum_topic;
use app\models\active\Forum_post;


class ForumController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
						'denyCallback' => function ($rule, $action) {
						return $this->redirect(['/site/index']);
							}
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

	public function actionIndex($id = 7)
	{

		
		$query = Forum_topic :: find();

		$pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('id DESC')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();


		return $this->render('razdel', ['count' => $query->count(),
										'pagination' => $pagination,
										'all' => $all
										]);


	}


	public function actionNew()
	{

		

		if(Yii::$app->user->identity->role == 0) return $this->redirect('/forum');

		$model = new \app\models\form\AddTopic();

		if ($model->load(Yii::$app->request->post()) && $model->validate()) {

			if(User :: BusinessCount() < 10  && Yii::$app->user->identity->role == 0 ){

				User :: Notice(['title' => 'Для создания топика необходимо открыть 10 бизнесов', 'status' => 'error']);
				return $this->goBack();

			}

			$topic = new Forum_topic();
			$topic->text = $model->text;
			$topic->name = $model->name;
			$topic->user = Yii::$app->user->id;
			$topic->save();



			    User::updateAll(['news_read' => $topic->id]);

		
			return $this->redirect('/forum/topic/'.$topic->id);

		}


		return $this->render('new', ['model' => $model]);



	}


	public function actionTopic($id = null, $reply = null)
	{

		$topic = Forum_topic :: findOne($id);

		if(!isset($topic->id)) return $this->redirect('/forum');

		$user = User :: findOne(Yii::$app->user->id);

		if($user->news_read == $topic->id){

		    $user->news_read = 0;
		    $user->save();

		}

		if($user->forum_reply == $topic->id)
		{

			$user->forum_reply = 0;
			$user->save();

		}

		$razdel = Forum_razdel :: findOne($topic->razdel);


		$model = new \app\models\form\ForumPost();


		$query = Forum_post :: find()->where(['topic' => $topic->id]);

		$pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('id DESC')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();


		if ($model->load(Yii::$app->request->post()) && $model->validate()) {


			if(User :: BusinessCount() < 10  && $user->role == 0){

				User :: Notice(['title' => 'Для отправки сообщения необходимо открыть 10 бизнесов', 'status' => 'error']);
				return $this->goBack();

			}


			if(isset($reply)){

				$us = User :: findOne($reply);
				if(isset($us->id))
				{

					$us->forum_reply = $topic->id;
					$us->save();

				}

				}

			$post = new Forum_post();
			$post->text = $model->text;
			$post->topic = $topic->id;
			$post->user = Yii::$app->user->id;
			$post -> save();

			return $this->redirect('/forum/topic/'.$id);


		}


		return $this->render('topic', ['topic' => $topic,
									   'model' => $model,
									   'count' => $query->count(),
									   'pagination' => $pagination,
									   'all' => $all,
									   'razdel' => $razdel,
									   'emoji' => \app\models\active\Chat :: Emoji(),
									   'emojihead' => \app\models\active\Chat :: EmojiHead(),
									   ]);


	}

	public function actionTopicClose($id = null)
	{
		$user = User :: findOne(Yii::$app->user->id);

		$topic = Forum_topic :: findOne($id);


		if(!isset($topic->id)) return $this->redirect('/forum');

		if($user->id != $topic->user && $user->role < 1) return $this->redirect('/forum');

		$status = $topic->close == 0 ? 1 : 0;

		$topic->close = $status;
		$topic->save();

		return $this->redirect('/forum/topic/'.$id);

	}

}
