<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use app\models\User;
use app\models\active\{Business,Mybusiness,Corp,Corphistory,Corpinvite};


class CorpController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
						'denyCallback' => function ($rule, $action) {
						return $this->redirect(['/site/index']);
							}
                    ],
                ],
            ],
        ];
    }


    public function actionIndex($id = null)
    {

		$corp = Corp :: findOne($id);

		if(!isset($corp->id)) return $this->goHome();

		$query = User :: find()->where(['corp' => $corp->id])->andWhere(['!=','id',$corp->user]);

		$key = User :: find()->where(['corp' => $corp->id])->sum('cup') ?? '0';

		$corp->cup= $key;
		$corp->save();

		return $this->render('index', ['corp' => $corp,
									   'count' => $query->count()+1,
									   'users' => $query->all(),
										]);


    }


	public function actionRating()
	{

		$query = Corp :: find();


		$pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('cup desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

		$count = ($pagination->getPage()+1)  > 1 ? ($pagination->getPage()+1)*10-9 : 1;

		$user = User :: findOne(Yii::$app->user->id);

		return $this->render('rating',
									  [
									   'pagination' => $pagination,
									   'all' => $all,
									   'count' => $count,
									   'user' => $user,
									   'query_count' => $query->count(),
									  ]

									);

	}


	public function actionCreat()
	{

		$user = User :: findOne(Yii::$app->user->id);

		if($user->corp != 0) return $this->goHome();

		$model = new \app\models\form\CreatCorp();

		if ($model->load(Yii::$app->request->post()) && $model->validate()) {

				if($user->ruby < 5000){

					User :: Notice(['status' => 'error', 'title' => 'Недостаточно рубинов']);
					return $this->redirect('/corp/creat');

				}

			$corp = new Corp();
			$corp->user = $user->id;
			$corp->name = $model->name;
			$corp->save();

			$user->corp = $corp->id;
			$user->position = 4;
			$user->ruby = $user->ruby - 5000;
			$user->save();

			User :: Notice(['status' => 'success', 'title' => 'Копрорация успешно создана']);

			return $this->redirect('/corp/'.$corp->id);

		}


		return $this->render('creat', ['model' => $model]);


	}


	public function actionTreasury()
	{


		$user = User :: findOne(Yii::$app->user->id);

		if($user->corp == 0) return $this->goHome();

		$model = new \app\models\form\Treasury();

		$corp = Corp :: findOne($user->corp);

		if ($model->load(Yii::$app->request->post()) && $model->validate()) {

				if($user->ruby < $model->ruby){

					User :: Notice(['status' => 'error', 'title' => 'Недостаточно рубинов']);
					return $this->redirect('/corp/treasury');

				}
				
				if(User :: BusinessCount() < 10 && empty($user->dump_business)){

				User :: Notice(['title' => 'Для пополнения склада необходимо открыть 10 бизнесов', 'status' => 'error']);
				return $this->redirect('/corp/treasury');

				}

			$user->ruby = $user->ruby-$model->ruby;
			$user->save();

			$corp->ruby = $corp->ruby+$model->ruby;
			$corp->save();

			$history = new Corphistory();
			$history->user = $user->id;
			$history->corp = $corp->id;
			$history->ruby = $model->ruby;
			$history->save();

			User :: Notice(['status' => 'success', 'title' => 'Склад успешно пополнен']);
			return $this->redirect('/corp/treasury');


		}

		$query = Corphistory :: find()->where(['corp' => $corp->id]);

		$pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('id desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();


		return $this->render('treasury', ['model' => $model,
										  'user' => $user,
										  'all' => $all,
										  'pagination' => $pagination,
											]);


	}


	public function actionStatue()
	{

		$user = User :: findOne(Yii::$app->user->id);

		$corp = Corp :: findOne($user->corp);

		if(!isset($corp->id)) return $this->goHome();

		if($user->position < 3) return $this->redirect('/corp/'.$corp->id);

		return $this->render('statue', ['corp' => $corp]);



	}

	public function actionGerb()
	{

		$user = User :: findOne(Yii::$app->user->id);

		$corp = Corp :: findOne($user->corp);

		if(!isset($corp->id)) return $this->goHome();

		if($user->position < 3) return $this->redirect('/corp/'.$corp->id);

		return $this->render('gerb', ['corp' => $corp]);



	}


	public function actionSetting()
	{

		$user = User :: findOne(Yii::$app->user->id);

		$corp = Corp :: findOne($user->corp);

		if(!isset($corp->id)) return $this->goHome();

		if($user->position < 3) return $this->goHome();

		$model = new \app\models\form\SettingCorp();

		$model->name = $corp->name;
		$model->status = $corp->status;

		if ($model->load(Yii::$app->request->post()) && $model->validate()) {


		    if($corp->ruby < 500 && $corp->name != $model->name){

		        User :: Notice(['status' => 'error', 'title' => 'Для смены названия необходимо 500 рубинов']);
		        return $this->redirect('/corp/setting');

		    }

		    if($corp->status != $model->status) User :: Notice(['status' => 'success', 'title' => 'Статус успешно изменен']);
		    if($corp->name != $model->name) User :: Notice(['status' => 'success', 'title' => 'Название успешно изменено']);
		    if($corp->name != $model->name && $corp->status != $model->status) User :: Notice(['status' => 'success', 'title' => 'Названиеи статус успешно изменено']);
		    if($corp->name != $model->name) $corp->ruby = $corp->ruby - 500;
			$corp->name = $model->name;
			$corp->status = $model->status;
			$corp->save();


			return $this->redirect('/corp/setting');

		}


		return $this->render('setting', ['model' => $model]);


	}


	public function actionNotice()
	{

		$user = User :: findOne(Yii::$app->user->id);

		$corp = Corp :: findOne($user->corp);

		if(!isset($corp->id)) return $this->goHome();

		if($corp->user != $user->id) return $this->goHome();

		$model = new \app\models\form\NoticeCorp();


		if ($model->load(Yii::$app->request->post()) && $model->validate()) {


			User::updateAll(['corp_notice' => $model->notice], ['corp' => $corp->id]);

			User :: Notice(['status' => 'success', 'title' => 'Сообщение отправлено']);

			return $this->redirect('/corp/notice');

		}


		return $this->render('notice', ['model' => $model]);


	}


	public function actionUserSetting($id)
	{


	    $who = User :: findOne($id);

	    if(!isset($who->id)) return $this->goBack();

	    $user = User :: findOne(Yii::$app->user->id);

	    $corp = Corp :: findOne($user->corp);

	    if($who->corp != $user->corp) return $this->goBack();


	    if($who->position >= $user->position || $user->position < 3){

	        User :: Notice(['title' => 'Вы не можете менять должность этому игроку', 'status' => 'error']);
	        return $this->redirect('/corp/'.$corp->id);

	    }


	    $model = new \app\models\form\UserSetting();

	    $items = range(0,$user->position-1);

	    $item = [];

	    foreach($items as $res):

	        $item[$res] =  Corp :: Position($res);

	   endforeach;


	   if ($model->load(Yii::$app->request->post()) && $model->validate()) {

	      $who->position = $model->position;
	      $who->save();

	      User :: Notice(['title' => 'Должность успешно изменена', 'status' => 'success']);
	      return $this->redirect('/corp/'.$corp->id);

	   }

	    return $this->render('user-setting', ['who' => $who, 'model' => $model, 'item' => $item]);




	}



}