<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use app\models\User;
use yii\helpers\Html;
use app\commands\Rounding;
use app\models\WapkassaClass;
use app\models\active\{Battles,
    Battles_user,
    Quest,
    Avatar,
    Corpinvite,
    Corp,
    Giftuser,
    Gift,
    Usericons,
    Icons,
    Chat,
    Mybusiness,
    Business,
    Friends};


class AjaxController extends Controller
{

    public $layout = 'ajax';


    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'chatSend' => ['post'],
                ],
            ],
        ];
    }

    public function actionKey()
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $session = Yii::$app->session;

        $session->open();

        if (!$session->get('key')) $session->set('key', time() + mt_rand(60, 120));


        if ($session->get('key') < time()) return json_encode(['status' => 'success']);

    }

    public function actionKeyGive()
    {


        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $session = Yii::$app->session;

        $session->open();

        if (!$session->get('key')) return false;


        if ($session->get('key') < time()) {


            $key = \app\models\active\Action:: Week() == 5 ? 2 : 1;

            $user->_key = $user->_key + $key;
            $user->save();

            $session->set('key', time() + mt_rand(60, 120));

            return json_encode(['status' => 'success', 'key' => $key]);

        }

    }


    public function actionBusiness()
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $query = Mybusiness:: find()->where(['user' => $user->id]);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('id DESC')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        $count = ($pagination->getPage() + 1) > 1 ? (int)$query->count() - (10 * $pagination->getPage()) : (int)$query->count();

        $view = $user->business_view == 0 ? 'business' : 'business_mini';

        User:: AchievementsSet($user->id, 3, $query->count());

        return $this->render($view, [
            'user' => $user,
            'mybusiness' => $all,
            'count' => $count
        ]);

    }


    public function actionBusinessView()
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $view = $user->business_view == 1 ? 0 : 1;

        $user->business_view = $view;
        $user->save();

        return json_encode(['type' => $user->business_view == 0 ? 'Компактный вид' : 'Обычный вид']);

    }


    public function actionNewsHide()
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $user->news_read = 0;
        $user->save();


    }

    public function actionBusinessUp($id = null, $col = 1)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        if (!in_array($col, [1, 10, 100, 'max'])) $col = 1;

        $business = Mybusiness:: findOne(['user' => $user->id, 'id' => $id]);

        if (isset($business->id) && $col == 'max') {

            Mybusiness:: MaxUp($business->id);
            return json_encode(['status' => 'success', 'title' => 'Бизнес успешно улучшен']);

        }

        $bsn = Business:: findOne($business->business);

        $price = Mybusiness:: Price($business->id, $col);

        if ($price > $user->money) return json_encode(['status' => 'error', 'title' => 'Недостаточно средств']);

        $income = $business->income_default;
        $k = 1;

        while ($k < $col) {

            $income = $income + $business->income_default;
            $k++;
        }
        $up = $business->level + $col > 10000 ? 10000 : $business->level + $col;

        $business->level = $up;
        $business->income = $business->income + $income;
        $business->save();

        if ($business->level >= 10000) {
            if (User:: Achievements($user->id, 11) < 10) {
                User:: AchievementsSet($user->id, 11, User:: Achievements($user->id, 11) + 1);
            }
        }

        $user->money = $user->money - $price;
        $user->save();

        return json_encode(['status' => 'success', 'title' => 'Бизнес успешно улучшен']);


    }


    public function actionUser($type = null)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        if (empty($type)) {
            return json_encode(['money' => Rounding:: Number($user->money), 'income' => Rounding:: Number(User:: Income())]);
        } else {
            return json_encode(['money' => $user->money, 'income' => User:: Income()]);
        }



    }

    public function actionFriends($who_id = null)
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $who = User:: findOne($who_id);

        if (!isset($who->id)) return;

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->id == $who->id) return;

        $friends = Friends:: findOne(['user' => $user->id, 'who' => $who->id]);

        if (isset($friends->id)) {

            $friends->delete();
            return json_encode(['title' => 'Игрок удален из друзей', 'status' => 'success', 'type' => 'Добавить в друзья']);

        } else {

            $friends = new Friends();
            $friends->user = $user->id;
            $friends->who = $who->id;
            $friends->save();

            return json_encode(['title' => 'Игрок добавлен в друзья', 'status' => 'success', 'type' => 'Убрать из друзей']);

        }


    }

    public function actionIncome()
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;


        $business = Mybusiness:: find()->select('income')->where(['user' => Yii::$app->user->id])->orderBy('income DESC')->one();

        $user = User:: findOne(Yii::$app->user->id);
        $online = time() - $user->online;
        $user->money = $user->money + User:: Income() * $online;
        $user->online = time();
        $user->time = $user->time + 1;
        $user->time_tourney = $user->time_tourney + 1;
        $user->income = User:: Income();
        $user->business = $business->income;
        //if(User :: ReferalCount() >= 5) $user->vip = 1;
        $user->save();

        User:: Online();

        User:: AchievementsSet($user->id, 7, round($user->time / 60 / 60));

        User:: AchievementsSet($user->id, 6, $user->ruby);

        User:: AchievementsSet($user->id, 5, $user->status);

        User:: AchievementsSet($user->id, 8, $user->income);


        //User :: QuestSet(6, $user->_key, 1);

        User:: QuestSet(7, 1);

        $quest_success = Quest:: find()->where(['user' => $user->id, 'price' => '1'])->count();

        User:: QuestSet(8, $quest_success, 1);

        //if($user->vip == 1) User :: AchievementsSet($user->id, 1, 1);
    }

    public function actionBusinessPrice($type = null)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $price = User:: BusinessPrice();


        $varib = $user->money > $price ? 0 : 1;

        if (empty($type)) {
            return json_encode(['status' => '1', 'price' => Rounding:: Number($price, 0), 'virib' => $varib]);
        } else {
            return json_encode(['status' => '1', 'price' => $price, 'virib' => $varib]);
        }

    }


    public function actionBusinessNew()
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $price = User:: BusinessPrice();

        if (!isset($price)) return;

        $user = User:: findOne(Yii:: $app->user->id);

        if ($price > $user->money) return json_encode(['status' => 'error', 'title' => 'Недостаточно средств']);

        $mybsn = Mybusiness:: find()->select('business,income_default,price_default')->where(['user' => Yii::$app->user->id])->orderBy('id DESC')->one();
        if (empty($mybsn)) {
            $mybsn = [
                'income_default' => 1,
                'price_default' => 1
            ];
        }

        $count = Mybusiness::find()->where(['user' => Yii::$app->user->id])->count();

        $bsn = Business:: find()->select('id')->orderBy('rand()')->one();


        $newbsn = new Mybusiness();
        $newbsn->user = $user->id;
        $newbsn->business = $bsn['id'];
        $newbsn->income = $mybsn['income_default'] * 2;
        $newbsn->income_default = $mybsn['income_default'] * 2;
        $newbsn->price_default = $mybsn['price_default'] * 10;
        $newbsn->save();

        $user->money = $user->money - $price;
        if ($user->free_business > 0) $user->free_business = $user->free_business - 1;
        $user->ruby = $user->ruby + (10 * $count);
        $user->save();

        User:: QuestSet(3, 1);

        return json_encode(['status' => 'success', 'title' => 'Бизнес успешно открыт']);


    }

    public function actionNotice()
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        Yii::$app->session->open();


        if (Yii::$app->session->get('notice')) {

            $notice = Yii::$app->session->get('notice');

            Yii::$app->session->remove('notice');

            if (!isset($notice['text'])) $notice['text'] = '';

            return json_encode($notice);

        }

        if (isset(Yii::$app->user->identity->corp_notice)) {

            $user = User:: findOne(Yii::$app->user->id);
            $notice = $user->corp_notice;
            $user->corp_notice = null;
            $user->save();

            return json_encode(['status' => 'info', 'title' => 'Рассылка корпорации', 'text' => $notice]);

        }


    }


    public function actionTourney()
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        if (Yii::$app->user->identity->angel_tourney_notice > 0) {

            $user = User:: findOne(Yii::$app->user->id);
            $notice = 'По результатам турнира вы заработали ' . Rounding:: Number($user->angel_tourney_notice) . ' рубинов';
            $user->angel_tourney_notice = 0;
            $user->save();

            return json_encode(['status' => 'info', 'title' => 'Результаты турнира', 'text' => $notice, 'url' => '/forum/topic/' . $user->angel_tourney_topic]);

        }


    }


    public function actionChat($type = null)
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $query = Chat:: find();

        $user = User:: findOne(Yii::$app->user->id);

        if ($type == 'corp') $query->where(['corp' => $user->corp]);

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count(),
        ]);

        $all = $query->orderBy('time DESC')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        if ($user->chat_reply == 1) {

            $user->chat_reply = 0;
            $user->save();
        }

        return $this->render('chat',
            [
                'count' => $query->count(),
                'pagination' => $pagination,
                'all' => $all,
            ]
        );


    }

    public function actionChatSend()
    {


        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $request = Yii::$app->request;

        $text = $request->post('text');
        $type = $request->post('type');
        $reply = $request->post('reply');

        if (empty(trim($text))) return json_encode(['status' => 'error', 'title' => 'Введите сообщение']);

        $user = User:: findOne(Yii::$app->user->id);

        $corp = $type == 'corp' ? $user->corp : 0;

        if (User:: BusinessCount() < 5 && $user->role == 0 && empty($user->dump_business)) {

            return json_encode(['title' => 'Для отправки сообщения необходимо открыть 5 бизнесов', 'status' => 'error']);


        }

        $chat = new Chat();
        $chat->user = Yii::$app->user->id;
        $chat->text = $text;
        $chat->corp = $corp;
        $chat->save();

        if (isset($reply)) {

            $us = User:: findOne($reply);
            if (isset($us->id)) {

                $us->chat_reply = 1;
                $us->save();

            }

        }

        return json_encode(['status' => 'success']);;


    }

    public function actionAutoUp()
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        Mybusiness:: AutoUp();

        return json_encode(['status' => 'success']);
    }


    public function actionUserStatus()
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;


        $user = User:: findOne(Yii::$app->user->id);


        if ($user->status == 3) return;

        if ($user->ruby < User:: Visa()->price) return json_encode(['status' => 'error', 'title' => 'Недостаточно рубинов']);

        $user->ruby = $user->ruby - User:: Visa()->price;
        $user->status = $user->status + 1;
        $user->save();

        User:: AchievementsSet($user->id, 5, 1);

        return json_encode(['status' => 'success', 'title' => 'Успешно']);

    }

    public function actionIconBuy($id = null)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $icon = Icons:: findOne($id);

        if (!isset($icon->id)) return;

        $user = User:: findOne(Yii::$app->user->id);

        $buy = Usericons:: find()->where(['user' => $user->id, 'icon' => $icon->id])->count();

        if ($buy > 0) return json_encode(['status' => 'error', 'title' => 'Иконка уже куплена']);


        $usicon = new Usericons();
        $usicon->user = $user->id;
        $usicon->icon = $icon->id;
        $usicon->sex = $icon->sex;
        $usicon->img = $icon->img;
        $usicon->save();

        return json_encode(['status' => 'success', 'title' => 'Иконка успешно куплена']);

    }


    /*
       public function actionIconSet($id = null)
       {

           if(Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

           $user = User :: findOne(Yii::$app->user->id);

           $icon = Usericons :: findOne(['icon' => $id, 'user' => $user->id]);

           if(!isset($icon->id)) return;


           if($icon->sex != $user->sex) return json_encode(['status' => 'error', 'title' => 'Для установки иконки необходимо сменить пол']);


           $user->icon = $icon->img;
           $user->save();

           return json_encode(['status' => 'success', 'title' => 'Иконка успешно установлена']);

       }
    */

    public function actionAvatarSet($id = null)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);
        $avatar = Avatar:: findOne(['img' => $id, 'sex' => $user->sex]);
        $cost = $user->free_avatar >= 1 ? 0 : 5000;

        if (!isset($avatar->id)) return;


        if ($avatar->sex != $user->sex) return json_encode(['status' => 'error', 'title' => 'Для установки аватара необходимо сменить пол']);

        if ($user->ruby < $cost) {
            return json_encode(['status' => 'error', 'title' => 'Недостаточно рубинов']);
        } else {
            if (!empty($cost)) {
                $user->ruby = $user->ruby - $cost;
            } else {
                if ($user->free_avatar >= 1) {
                    $user->free_avatar = $user->free_avatar - 1;
                }
            }

            $user->avatar = $avatar->img;
            $user->save();

            return json_encode(['status' => 'success', 'title' => 'Аватар успешно установлен']);
        }
    }


    public function actionGerbSet($id = null)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $corp = Corp:: findOne($user->corp);

        if (!isset($corp->id)) return;

        if ($user->position < 3) return;

        if (!in_array($id, range(1, 10))) return;

        if ($corp->ruby < 5000) return json_encode(['status' => 'error', 'title' => 'Недостаточно рубинов']);

        $corp->gerb = $id;
        $corp->ruby = $corp->ruby - 5000;
        $corp->save();


        return json_encode(['status' => 'success', 'title' => 'Герб успешно установлен']);

    }

    public function actionUserBonus()
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->bonus >= 5) return;

        $price = Yii::$app->params['bonus'][$user->bonus];

        if ($user->angel < $price) return json_encode(['status' => 'error', 'title' => 'Недостаточно средств']);

        $user->bonus = $user->bonus + 1;
        $user->save();


        return json_encode(['status' => 'success', 'title' => 'Успешно']);

    }

    public function actionPayment($amount)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        //$amount = \app\models\active\Action :: Week() == 3 ? $amount/2 : $amount;


        try {
            $wapkassa = new WapkassaClass(Yii::$app->params['wapkassa']['id'], Yii::$app->params['wapkassa']['secret']);

            $wapkassa->setParams((float)$amount, 'Покупка рубинов');

            $wapkassa->setParamsAdd([
                'user_id' => $user->id
            ]);


            $formValue = $wapkassa->getValue();
            //$value = $wapkassa->getPaymentUrl();
            //return var_dump(http_build_query($formValue));

            /*
            if (!empty($value['success'])) {
                return json_encode(['status' => 'success', 'url' => $value['success']['url']]);
            }
            */

            return json_encode(['status' => 'success', 'url' => 'https://wapkassa.ru/merchant/payment2?' . http_build_query($formValue, '', '&')]);

        } catch (\Exception $e) {

            return json_encode(['status' => 'error', 'title' => $e->getMessage()]);

        }


    }


    public function actionSearch($name = null)
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(['username' => $name]);

        if (!isset($user->id)) return json_encode(['status' => 'error', 'title' => 'Игрок не найден']);

        return json_encode(['status' => 'success', 'user' => $user->id]);

    }


    public function actionStatueUp()
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $corp = Corp:: findOne($user->corp);

        if (!isset($corp->id)) return;

        if ($corp->user != $user->id or $corp->statue >= 15) return;

        $price = ($corp->statue + 1) * 1000;

        if ($corp->ruby < $price) return json_encode(['status' => 'error', 'title' => 'Недостаточно рубинов']);

        $corp->ruby = $corp->ruby - $price;
        $corp->statue++;
        $corp->save();

        return json_encode(['status' => 'success', 'title' => 'Статуя успешно улучшена']);

    }

    public function actionVacancyUp()
    {
        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $corp = Corp:: findOne($user->corp);

        if (!isset($corp->id)) return;

        if ($corp->user != $user->id or $corp->vacancy >= 30) return;

        $price = ($corp->vacancy + 1) * 200;

        if ($corp->ruby < $price) return json_encode(['status' => 'error', 'title' => 'Недостаточно рубинов']);

        $corp->ruby = $corp->ruby - $price;
        $corp->vacancy++;
        $corp->save();

        return json_encode(['status' => 'success', 'title' => 'Место успешно куплено']);

    }


    public function actionInvite($user_id)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $corp = Corp:: findOne($user->corp);

        if (!isset($corp->id)) return;

        if ($corp->user != $user->id) return;


        $who = User:: findOne($user_id);

        if (!isset($who->id)) return;


        if ($who->corp != 0) return;

        $invite = Corpinvite:: findOne(['user' => $who->id, 'corp' => $corp->id]);

        if (isset($invite->id)) $invite->delete();

        $invite = new Corpinvite();
        $invite->user = $who->id;
        $invite->corp = $corp->id;
        $invite->save();

        return json_encode(['status' => 'success', 'title' => 'Приглашение в клан отправлено']);


    }


    public function actionInviteUser($id = null, $type = 0)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $invite = Corpinvite:: findOne(['id' => $id, 'user' => $user->id]);

        $corp = Corp:: findOne($invite->corp);

        $corp_user = Corp:: find()->where(['id' => $corp->id])->count();

        if ($corp_user >= $corp->vacancy) return json_encode(['status' => 'error', 'title' => 'В корпорации нет мест']);

        if (!isset($invite->id)) return;

        if ($type == 1) {

            $invite->delete();

            return json_encode(['status' => 'success', 'title' => 'Приглашение в клан отклонено']);

        }

        if ($type == 0) {

            $user->corp = $invite->corp;
            $user->save();

            Corpinvite::deleteAll(['user' => $user->id]);

            return json_encode(['status' => 'success', 'title' => 'Вы вступили в корпорацию']);


        }

    }


    public function actionDeleteCorp()
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $corp = Corp:: findOne(['user' => $user->id]);

        if (!isset($corp->id)) return;

        User::updateAll(['corp' => '0', 'position' => '0'], ['corp' => $corp->id]);

        $corp->delete();


        return json_encode(['status' => 'success', 'title' => 'Корпорация удалена']);


    }

    public function actionCorpCardActive()
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $corp = Corp:: findOne($user->corp);

        if (!isset($corp->id)) return;

        if ($user->position < 3) return;

        if ($corp->ruby < 5000) return User:: Notice(['title' => 'Недостаточно рубинов', 'text' => '', 'status' => 'error']);

        $corp->ruby = $corp->ruby - 5000;
        $corp->card = $corp->card < time() ? time() + 86400 : $corp->card + 86400;
        $corp->save();

        return User:: Notice(['title' => 'Корпоративная карта активирована', 'text' => 'Бонус к доходу в секунду увеличен в 2 раза участникам корпорации!', 'status' => 'success']);

    }

    public function actionDeleteUser($user_id)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        $corp = Corp:: findOne(['user' => $user->id]);


        if (!isset($corp->id)) return;

        $who = User:: findOne(['corp' => $corp->id, 'id' => $user_id]);

        if (!isset($who->id)) return;


        $who->corp = 0;
        $who->position = 0;
        $who->save();

        User:: Notice(['status' => 'success', 'title' => 'Игрок удален из корпорации']);


    }


    public function actionExitCorp()
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;


        $user = User:: findOne(Yii::$app->user->id);

        if ($user->corp == 0) return;

        $user->corp = 0;
        $user->position = 0;
        $user->save();


        return json_encode(['status' => 'success', 'title' => 'Вы покинули корпорацию']);


    }

    public function actionMailNew()
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        if (User:: Mail()) return json_encode(['status' => 1]);
    }

    public function actionChest($type = null)
    {

        if (Yii::$app->user->isGuest || !Yii::$app->request->isAjax) return;

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->_key < 1 && $user->ruby < 15) return json_encode(['status' => 'error', 'title' => 'Для открытия сундука необходим ключ или 15 рубинов']);

        $key = $type == 1 ? $user->_key : 1;

        $key = $user->_key == 0 && $user->ruby > 15 ? 1 : $key;

        $count = 0;

        while ($count < $key):

            $chest = User:: RandChest();

            if ($user->_key > 0):
                $user->_key = $user->_key - 1;
            else:
                $user->ruby = $user->ruby - 15;
            endif;

            User:: AchievementsSet($user->id, 2, User:: Achievements($user->id, 2) + 1);

            User:: QuestSet(1, 1);

            if ($chest <= 45) {

                $ruby = rand(5, 10);

                $user->ruby = $user->ruby + $ruby;

                User:: QuestSet(4, $ruby);

                $return[] = 'Вы выиграли ' . $ruby . ' ' . Html::img('@web/images/ruby.png', ['width' => 20]);

            }

            if ($chest > 45 && $chest <= 90) {


                $user->money = $user->money + $user->income * 100;


                $return[] = 'Вы выиграли ' . Rounding:: Number(($user->income * 100)) . ' ' . Html::img('@web/images/header/money_36.png', ['width' => 20]);

            }

            if ($chest == 90) {

                $ruby = 5000;
                $user->lucky = time();
                $user->lucky_value = $ruby . ' ' . Html::img('@web/images/ruby.png', ['width' => 20]);
                $user->ruby = $user->ruby + $ruby;

                User:: QuestSet(4, $ruby);

                $return[] = 'Вы выиграли ' . $ruby . ' ' . Html::img('@web/images/ruby.png', ['width' => 20]);

            }


            if ($chest > 90 && $chest <= 92) {

                $user->lucky = time();
                $user->lucky_value = 'Бесплатный бизнес';
                $user->free_business = $user->free_business + 1;

                $return[] = 'Поздравляем! Вам выпала возможность купить следующий бизнес бесплатно!';

            }

            if ($chest > 92 && $chest <= 94) {

                $user->lucky = time();
                $user->bonus_chest = $user->bonus_chest + 1;
                $user->lucky_value = 'X2 к доходу';

                $return[] = 'Поздравляем! Ваш доход в секунду увеличен в 2 раза!';
            }


            $count++;
        endwhile;

        $user->save();

        $json = null;

        foreach ($return as $rtn):

            $json .= $rtn . PHP_EOL;

        endforeach;


        if (isset($json)) return json_encode(['status' => 'success', 'title' => nl2br($json), 'key' => $user->_key]);

    }

}