<?php

namespace app\controllers;

use app\models\active\Action;
use app\models\active\Donate;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use app\models\User;
use app\models\active\Forum_topic;
use app\models\active\Forum_post;
use app\models\active\Chat;


class AdminController extends Controller
{

    public function actionBlock($user_id)
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 1) return $this->goHome();

        $who = User:: findOne($user_id);

        if ($who->ban > time()) {

            $who->ban = 0;
            $who->save();

            User:: Notice(['status' => 'success', 'title' => 'Игрок успешно разблокирован']);
            return $this->redirect('/user/' . $who->id);

        }

        if (!isset($who->id)) return $this->goHome();

        $model = new \app\models\form\Block();

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {

            $who->ban = time() + $model->time * 3600;
            $who->save();
            User:: Notice(['status' => 'success', 'title' => 'Игрок успешно заблокирован']);
            return $this->redirect('/user/' . $who->id);

        }


        return $this->render('block', ['model' => $model, 'who' => $who]);


    }


    public function actionMd($user_id)
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 2) return $this->goHome();

        $who = User:: findOne($user_id);

        if ($who->role == 1) {

            $who->role = 0;
            $who->save();

            User:: Notice(['status' => 'success', 'title' => 'Игрок снят с должности']);
            return $this->redirect('/user/' . $who->id);

        }


        if ($who->role == 0) {

            $who->role = 1;
            $who->save();

            User:: Notice(['status' => 'success', 'title' => 'Игрок назначен на должность']);
            return $this->redirect('/user/' . $who->id);

        }

        return $this->redirect('/user/' . $who->id);


    }


    public function actionEditTopic($id = null)
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 1) return $this->goHome();

        $topic = Forum_topic:: findOne($id);

        if (!isset($topic->id)) return $this->goHome();

        $model = new \app\models\form\AddTopic();

        $model->name = $topic->name;
        $model->text = $topic->text;


        if ($model->load(Yii::$app->request->post()) && $model->validate()) {

            $topic->name = $model->name;
            $topic->text = $model->text;
            $topic->save();

            User:: Notice(['status' => 'success', 'title' => 'Топик успешно отредактирован']);
            return $this->redirect('/forum/topic/' . $topic->id);

        }

        return $this->render('edit-topic', ['model' => $model, 'topic' => $topic]);


    }

    function actionDeleteChat($id = null)
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 1) return $this->goHome();


        $chat = Chat:: findOne($id);
        $chat->delete();

        return $this->redirect('/chat');


    }


    function actionDeletePost($id = null)
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 1) return $this->goHome();


        $post = Forum_post:: findOne($id);
        $post->delete();

        return $this->redirect('/forum/topic/' . $post->topic);


    }


    function actionDelTopic($id = null)
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 1) return $this->goHome();


        $topic = Forum_topic:: findOne($id);

        if (!isset($topic->id)) return $this->goHome();

        Forum_post::deleteAll(['topic' => $topic->id]);

        $topic->delete();

        return $this->redirect('/forum/topic/' . $topic->id);


    }

    public function actionIndex($reset = null)
    {
        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 2) return $this->goHome();


        $donates = Donate::find()->count();
        return $this->render('index', [
            'donates' => $donates
        ]);


    }


    public function actionDrop()
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 2) return $this->goHome();


        $model = new \app\models\form\DropGame();

        if ($model->load(Yii::$app->request->post()) /*&& $model->validate()*/) {

            $array = [
                'achievements',
                'chat',
                'corp',
                'corphistory',
                'corpinvite',
                'dialog',
                'forum_post',
                'forum_topic',
                'giftuser',
                'mail',
                'mybusiness',
                'quest',
                'usericons',
                'users',
                'tourneyuser',
                'items',
                'battles_log',
                'battles_user',
                'battles_top',
                'journal',
                'donate'
            ];



            foreach ($array as $res):

                Yii::$app->db->createCommand()->truncateTable($res)->execute();

            endforeach;
            User::deleteAll([
                'AND',
                ['not in', 'id', [0, 0]],
            ]);

            User::updateAll(['strike' => 10, 'defend' => 10, 'health' => 10]);

            return $this->goHome();
        }

        return $this->render('drop', ['model' => $model]);


    }

    public function actionOnline()
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 2) return $this->goHome();

        $model = new \app\models\form\TimeOnline();

        $setting = \app\models\active\Setting:: findOne(1);

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {

            $setting->online = $model->time;
            $setting->save();

            return $this->redirect('/admin/online');

        }

        $model->time = $setting->online;

        return $this->render('online', ['model' => $model]);


    }


    public function actionRuby($id = null)
    {

        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 2) return $this->goHome();

        $model = new \app\models\form\UserGiveRuby();

        $who = User:: findOne($id);


        if ($model->load(Yii::$app->request->post()) && $model->validate()) {

            if (!isset($model->ruby)) return $this->redirect('/admin/ruby?id=' . $model->id);

            if (isset($who->id) && isset($model->ruby)) {
                $who->ruby = $model->ruby;
                $who->save();

                User:: Notice(['title' => 'Успешно', 'status' => 'success']);

                return $this->redirect('/admin/ruby');

            }
        }


        return $this->render('ruby', ['model' => $model, 'who' => $who]);


    }

    public function actionLogDonate()
    {
        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 2) return $this->goHome();

        $query = Donate::find();

        $pagination = new Pagination([
            'defaultPageSize' => 10,
            'totalCount' => $query->count()
        ]);

        $data = $query->orderBy('time desc')
            ->offset($pagination->offset)
            ->limit($pagination->limit)
            ->all();

        return $this->render('log-donate', [
            'data' => $data,
            'pagination' => $pagination
        ]);
    }

    public function actionLogRefs($user_id)
    {
        if (Yii::$app->user->isGuest) return $this->goHome();

        $user = User:: findOne(Yii::$app->user->id);

        if ($user->role < 2) return $this->goHome();
        if (empty($user_id) || !is_numeric($user_id)) return $this->goHome();

        $who = User:: findOne($user_id);

        if (empty($who)) return $this->goHome();

        $refs = User::find()->where(['ref' => $who->id])->all();

        return $this->render('log-refs', [
            'refs' => $refs
        ]);
    }

}
