<?php


namespace app\assets;

use Yii;
use yii\web\AssetBundle;


class AppAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css;
    public $js = [
		'assets/sweetalert.min.js'
    ];
    public $depends = [
		'yii\web\YiiAsset',
    ];

    public function init()
    {
        parent::init(); // TODO: Change the autogenerated stub
        $style = !empty(Yii::$app->user->identity->style) ? Yii::$app->user->identity->style : 'dark';
        $this->css = [
            'css/'. $style .'.css?'.microtime(),
            'css/bootstrap-grid.min.css?'.microtime(),
        ];
    }
}
