<?php

namespace app\models\active;

use Yii;
use yii\helpers\Html;
use yii\db\ActiveRecord;
use app\commands\Rounding;

class Action extends ActiveRecord
{
    
    static public function Current()
    {
        
        $action = static :: findOne(static :: Week());
        
        if(!isset($action->id)) return false;
        
        if(!isset($action->url)) return Html::tag('span', $action->name, ['class' => 'action', 'style' => 'color: green; font-weight: 900;']) .'<br>'. Html::tag('span', static::Time(), ['style' => 'color:red']);
        
        return '<b>'.Html::a($action->name.'<br> '.Html::tag('span', static::Time(), ['style' => 'color:red']), [$action->url], ['class' => 'action', 'style' => 'color: green; font-weight: 900;']).'</b>';
        
    }
    
    static public function Time()
    {
        
        return Rounding :: Number(strtotime('today')+86400-time(), 0, 3);
        
    }
    
    static public function Week()
    {
      return date('w');
    }
}