<?php

declare(strict_types=1);

return [

    /*
    |--------------------------------------------------------------------------
    | Content Creation
    |--------------------------------------------------------------------------
    |
    | From what TL level is it possible to create content.
    | С какого уровня TL возможно создавать контент.
    |
    */

    'tl_add_blog'       => 1,
    'tl_add_topic'      => 10,
    'tl_add_category'   => 10, // Catalog (каталог)
    'tl_add_section'    => 10, // Service pages (служебные страницы)
    'tl_add_team'       => 1,

    'tl_add_post'       => 1,
    'tl_add_answer'     => 1,
    'tl_add_comment'    => 1,
    'tl_add_item'       => 2, // Catalog (каталог)
    'tl_add_reply'      => 2, // Catalog (каталог)

    'tl_add_pm'         => 2, // Private messages (личные сообщения)

    // С какого TL можно комментировать ответы в QA модели
    'tl_add_comm_qa'    => 2,
    // С какого TL можно размещать ссылки: Reddit
    'tl_add_url'        => 3,

    // Уровень TL, до которого (включая) отправка жалоб невозможна
    // TL level, up to which (including) sending complaints is not possible
    'tl_add_report'     => 2,


    /*
    |--------------------------------------------------------------------------
    | Initial limits
    |--------------------------------------------------------------------------
    |
    | Initial limits for content creation in 1 day
    | Начальные лимиты на создание контента за 1 день
    |
    */

    'perDay_blog'       => 1,
    'perDay_topic'      => 0,
    'perDay_category'   => 0, // Catalog (каталог)
    'perDay_section'    => 0, // Service pages (служебные страницы)
    'perDay_team'       => 3,

    'perDay_post'       => 3,
    'perDay_answer'     => 5,
    'perDay_comment'    => 8,
    'perDay_item'       => 1, // Catalog (каталог)
    'perDay_reply'      => 3, // Catalog (каталог)

    'perDay_pm'         => 10, // Private messages (личные сообщения)

    'perDay_report'     => 3,


    /*
    |--------------------------------------------------------------------------
    | Odds for limits
    |--------------------------------------------------------------------------
    |
    | Odds for limits depending on the level of trust for 1 day
    | Коэффициенты на лимиты в зависимости от уровня доверия на 1 день
    |
    */

    'multiplier_1'       => 1,
    'multiplier_2'       => 2,
    'multiplier_3'       => 3,
    'multiplier_4'       => 4,

];
