<?
class ZSecurity{
	const SELF = 'ZSecurity';
	private static $instance = null;

	public static function &init(
		$A = null,
		$Aclass = null,
		$Aunique = true
	){
		$_class = ($Aclass === null) ? __CLASS__ : (string)$Aclass;
		$_unique = ((bool)$Aunique === false) ? false : true;
		if(!class_exists($_class)):
			$_return = false;
		elseif(is_object(self::$instance)):
			$_return = &self::$instance;
		elseif((self::$instance === null) && $_unique):
			self::$instance = new $_class($A);
			$_return = &self::$instance;
		else:
			self::$instance = false;
			$_return = new $_class($A);
		endif;
		return $_return;
	}

	protected function __construct(
		$A
	){
		global $_POST;
		$_POST = $this->tagCLEAN($_POST);
		$_POST = $this->htmlspecialchars($_POST);
	}

	public function __destruct(){
	}

	final public function htmlspecialchars(
		$A
	){
		if(is_string($A)):
			$_pattern = array('&', "'", '"', '<', '>', '\\');
			$_replacement = array('&amp;', '&#039;', '&quot;', '&lt;', '&gt;', '\\\\');
			$_return = str_replace($_pattern, $_replacement, $A);
		elseif(is_array($A)):
			$_function = __FUNCTION__;
			foreach($A as &$_value):
				$_value = $this->$_function($_value);
			endforeach;
			$_return = &$A;
		else:
			$_return = null;
		endif;
		return $_return;
	}

	final public function unhtmlspecialchars(
		$A
	){
		if(is_string($A)):
			$_pattern = array('&amp;', '&#039;', '&quot;', '&lt;', '&gt;', '\\\\');
			$_replacement = array('&', "'", '"', '<', '>', '\\');
			$_return = str_replace($_pattern, $_replacement, $A);
		elseif(is_array($A)):
			$_function = __FUNCTION__;
			foreach($A as &$_value):
				$_value = $this->$_function($_value);
			endforeach;
			$_return = &$A;
		else:
			$_return = null;
		endif;
		return $_return;
	}

	public function tagCLEAN(
		$A,
		$Atag_alloweded = null
	){
		if($Atag_alloweded === null):
			$_tag_alloweded = null;
		elseif(is_scalar($Atag_alloweded)):
			$_tag_alloweded = (string)$Atag_alloweded;
		elseif(is_array($Atag_alloweded)):
			$_tag_alloweded = join(' ', (string)$Atag_alloweded);
		else:
			$_tag_alloweded = null;
		endif;
		//
		if(is_scalar($A)):
			$_return = strip_tags($A, $_tag_alloweded);
		elseif(is_array($A)):
			foreach($A as &$_value)
				$_value = $this->tagCLEAN($_value, $_tag_alloweded);
			$_return = &$A;
		else:
			$_return = null;
		endif;
		return $_return;
	}
}
$ZSECURITY = &ZSecurity::init();
?>