/*
---

name: "Types.Function"

description: "Contains function manipulation methods."

license:
	- "[GNU Lesser General Public License](http://opensource.org/licenses/lgpl-license.php)"
	- "[MIT License](http://opensource.org/licenses/mit-license.php)"

requires:
	- Core
	- Types.Array

provides: Types.Function

...
*/

atom.fn = {
	lambda: function (value) {
		var returnThis = (arguments.length == 0);
		return function () { return returnThis ? this : value; };
	},

	after: function (onReady, fnName) {
		var after = {}, ready = {};
		function checkReady (){
			for (var i in after) if (!ready[i]) return;
			onReady(ready);
		}
		slice.call(arguments, 1).forEach(function (key) {
			after[key] = function () {
				ready[key] = slice.call(arguments);
				ready[key].context = this;
				checkReady();
			};
		});
		return after;
	}
};
