<?php
/**
*
* @package Support Toolkit - phpbb Russian language Sheer
* @version $Id$
* @copyright (c) 2009 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/
/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

/**
* DO NOT CHANGE
*/
if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'EVENTS'				=> 'Events',
	'EVENTS_EXPLAIN'		=> 'Complete list of events can be found at <a href="https://wiki.phpbb.com/Event_List" target="_blank">phpBB Development Wiki (Area51 phpBB)</a>',
	'CONTENTS'				=> 'Contents',
	'PHP_EVENTS'			=> 'PHP Events (Hook Locations)',
	'TEMPLATE_EVENTS'		=> 'Template Events',
	'ACP_TEMPLATE_EVENTS'	=> 'ACP Template Events',
	'IDENTIFIER'			=> 'Identifier',
	'PLACEMENT'				=> 'Placement',
	'ARGUMENTS'				=> 'Arguments',
	'EXPLANATION'			=> 'Explanation',
	'VERSION_E'				=> 'Version',

	'ACP_BAN_AFTER'							=> 'Use this event to perform actions after the ban has been performed',
	'ACP_BAN_BEFORE'						=> 'Use this event to modify the ban details before the ban is performed',
	'ACP_BBCODES_DISPLAY_BBCODES'			=> 'Modify display of custom bbcodes in the form',
	'ACP_BBCODES_DISPLAY_FORM'				=> 'Modify custom bbcode template data before we display the form',
	'ACP_BBCODES_EDIT_ADD'					=> 'Modify custom bbcode template data before we display the add/edit form',
	'ACP_BBCODES_MODIFY_CREATE'				=> 'Modify custom bbcode data before the modify/create action',
	'ACP_BOARD_CONFIG_EDIT_ADD'				=> 'Event to add and/or modify acp_board configurations',
	'ACP_EMAIL_MODIFY_SQL'					=> 'Modify sql query to change the list of users the email is sent to',
	'ACP_EMAIL_SEND_BEFORE'					=> 'Modify email template data before the emails are sent',
	'ACP_MAIN_NOTICE'						=> 'Notice admin',
	'ACP_MANAGE_FORUMS_DISPLAY_FORM'		=> 'Modify forum template data before we display the form',
	'ACP_MANAGE_FORUMS_INITIALISE_DATA'		=> 'Initialise data before we display the add/edit form',
	'ACP_MANAGE_FORUMS_MOVE_CHILDREN'		=> 'Event when we move all children of one forum to another',
	'ACP_MANAGE_FORUMS_MOVE_CONTENT'		=> 'Event when we move content from one forum to another',
	'ACP_MANAGE_FORUMS_REQUEST_DATA'		=> 'Request forum data and operate on it (parse texts, etc.)',
	'ACP_MANAGE_FORUMS_UPDATE_DATA_AFTER'	=> 'Event after a forum was updated or created',
	'ACP_MANAGE_FORUMS_UPDATE_DATA_BEFORE'	=> 'Remove invalid values from forum_data_sql that should not be updated',
	'ACP_MANAGE_FORUMS_VALIDATE_DATA'		=> 'Validate the forum data before we create/update the forum',
	'ACP_MANAGE_GROUP_DISPLAY_FORM'			=> 'Modify group template data before we display the form',
	'ACP_MANAGE_GROUP_INITIALISE_DATA'		=> 'Initialise data before we display the add/edit form',
	'ACP_MANAGE_GROUP_REQUEST_DATA'			=> 'Request group data and operate on it',
	'ACP_RANKS_EDIT_MODIFY_TPL_ARY'			=> 'Modify the template output array for editing/adding ranks',
	'ACP_RANKS_LIST_MODIFY_RANK_ROW'		=> 'Modify the template output array for each listed rank',
	'ACP_RANKS_SAVE_MODIFY_SQL_ARY'			=> 'Modify the SQL array when saving a rank',
	'ACP_USERS_DISPLAY_OVERVIEW'			=> 'Add additional quick tool options and overwrite user data',
	'ACP_USERS_OVERVIEW_BEFORE'				=> 'Run code at beginning of ACP users overview',
	'ACP_USERS_OVERVIEW_MODIFY_DATA'		=> 'Modify user data before we update it',
	'ACP_USERS_OVERVIEW_RUN_QUICKTOOL'		=> 'Run custom quicktool code',
	'ACP_USERS_PREFS_MODIFY_DATA'			=> 'Modify users preferences data',
	'ACP_USERS_PREFS_MODIFY_SQL'			=> 'Modify SQL query before users preferences are updated',
	'ACP_USERS_PREFS_MODIFY_TEMPLATE_DATA'	=> 'Modify users preferences data before assigning it to the template',
	'ADD_FORM_KEY'							=> 'Perform additional actions on creation of the form token',
	'ADD_LOG'								=> 'Allows to modify log data before we add it to the database',
	'ADM_PAGE_FOOTER'						=> 'Execute code and/or overwrite adm_page_footer()',
	'ADM_PAGE_HEADER'						=> 'Execute code and/or overwrite adm_page_header()',
	'ADM_PAGE_HEADER_AFTER'					=> 'Execute code and/or overwrite _common_ template variables after they have been assigned.',
	'APPEND_SID'							=> 'This event can either supplement or override the append_sid() function',
	'BBCODE_CACHE_INIT_END'					=> 'Use this event to modify the bbcode_cache',
	'BUILD_CONFIG_TEMPLATE'					=> 'Overwrite the html code we display for the config value',
	'COMMON'								=> 'Main event which is triggered on every page',
	'DECODE_MESSAGE_AFTER'					=> 'Use this event to modify the message after it is decoded',
	'DECODE_MESSAGE_BEFORE'					=> 'Use this event to modify the message before it is decoded',
	'DELETE_GROUP_AFTER'					=> 'Event after a group is deleted',
	'DELETE_LOG'							=> 'Allows to modify log data before we delete it from the database',
	'DELETE_PM_BEFORE'						=> 'Get all info for PM(s) before they are deleted',
	'DELETE_POSTS_AFTER'					=> 'Perform additional actions after post(s) deletion',
	'DELETE_POSTS_BEFORE'					=> 'Perform additional actions before post(s) deletion',
	'DELETE_POSTS_IN_TRANSACTION'			=> 'Perform additional actions during post(s) deletion',
	'DELETE_USER_AFTER'						=> 'Event after a user is deleted',
	'DELETE_USER_BEFORE'					=> 'Event before a user is deleted',
	'DISPLAY_CUSTOM_BBCODES'				=> 'Display custom bbcodes',
	'DISPLAY_CUSTOM_BBCODES_MODIFY_ROW'				=> 'Event to modify the template data block of a custom bbcode',
	'DISPLAY_CUSTOM_BBCODES_MODIFY_SQL'				=> 'Event to modify the SQL query before custom bbcode data is queried',
	'DISPLAY_FORUMS_ADD_TEMPLATE_DATA'				=> 'Modify and/or assign additional template data for the forum',
	'DISPLAY_FORUMS_AFTER'							=> 'Event to perform additional actions after the forum list has been generated',
	'DISPLAY_FORUMS_MODIFY_CATEGORY_TEMPLATE_VARS'	=> 'Modify the template data block of the category',
	'DISPLAY_FORUMS_MODIFY_FORUM_ROWS'				=> 'Event to modify the forum rows data set',
	'DISPLAY_FORUMS_MODIFY_ROW'						=> 'Event to modify the data set of a forum',
	'DISPLAY_FORUMS_MODIFY_SQL'						=> 'Event to modify the SQL query before the forum data is queried',
	'DISPLAY_FORUMS_MODIFY_TEMPLATE_VARS'			=> 'Modify the template data block of the forum',
	'DISPLAY_USER_ACTIVITY_MODIFY_ACTIVES'			=> 'Alter list of forums and topics to display as active',
	'FUNCTIONS_REDIRECT'							=> 'Execute code and/or overwrite redirect()',
	'GARBAGE_COLLECTION'							=> 'Unload some objects, to free some memory, before we finish our task',
	'GEN_SORT_SELECTS_AFTER'						=> 'Run code before generated sort selects are returned',
	'FAQ_MODE_VALIDATION'							=> 'You can use this event display a custom help page',
	'GENERATE_PROFILE_FIELDS_TEMPLATE_DATA'			=> 'Event to modify template data of the generated profile fields',
	'GENERATE_PROFILE_FIELDS_TEMPLATE_DATA_BEFORE'	=> 'Event to modify data of the generated profile fields, before the template assignment loop',
	'GENERATE_SMILIES_AFTER'						=> 'This event is called after the smilies are populated',
	'GET_LOGS_AFTER'								=> 'Allow modifying or execute extra final filter on log entries',
	'GET_LOGS_GET_ADDITIONAL_DATA'					=> 'Get some additional data after we got all log entries',
	'GET_LOGS_MODIFY_ENTRY_DATA'					=> 'Modify the entry\'s data before it is returned',
	'GET_LOGS_MODIFY_TYPE'							=> 'Overwrite log type and limitations before we count and get the logs',
	'GRAB_PROFILE_FIELDS_DATA'						=> 'Event to modify profile fields data retrieved from the database',
	'GROUP_DELETE_USER_BEFORE'						=> 'Event before users are removed from a group',
	'INDEX_MODIFY_PAGE_TITLE'						=> 'You can use this event to modify the page title and load data for the index',
	'LOAD_DRAFTS_DRAFT_LIST_RESULT'					=> 'Drafts found and their topics',
	'LOGIN_BOX_BEFORE'								=> 'This event allows an extension to modify the login process',
	'LOGIN_BOX_FAILED'								=> 'This event allows an extension to process when a user fails a login attempt',
	'LOGIN_BOX_REDIRECT'							=> 'This event allows an extension to modify the redirection when a user successfully logs in',
	'LOGIN_FORUM_BOX'								=> 'Performing additional actions, load additional data on forum login',
	'MCP_BAN_AFTER'									=> 'Use this event to perform actions after the ban has been performed',
	'MCP_BAN_BEFORE'								=> 'Use this event to modify the ban details before the ban is performed',
	'MCP_BAN_CONFIRM'								=> 'Use this event to pass data from the ban form to the confirmation screen',
	'MCP_BAN_MAIN'									=> 'Use this event to pass perform actions when a ban is issued or revoked',
	'MCP_FRONT_REPORTS_LISTING_QUERY_BEFORE'		=> 'Alter sql query to get latest reported posts',
	'MCP_FRONT_VIEW_QUEUE_POSTID_LIST_AFTER'		=> 'Alter list of posts and total as required',
	'MCP_GLOBAL_F_READ_AUTH_AFTER'					=> 'Allow applying additional permissions to MCP access besides f_read',
	'MCP_QUEUE_GET_POSTS_FOR_TOPICS_QUERY_BEFORE'	=> 'Alter sql query to get information on all topics in the list of forums provided.',
	'MCP_QUEUE_GET_POSTS_QUERY_BEFORE'				=> 'Alter sql query to get posts in queue to be accepted',
	'MCP_REPORTS_GET_REPORTS_QUERY_BEFORE'			=> 'Alter sql query to get report id of all reports for requested forum and topic or just forum',
	'MCP_VIEW_FORUM_MODIFY_SQL'						=> 'Modify SQL query before MCP forum view topic list is queried',
	'MCP_VIEW_FORUM_MODIFY_TOPICROW'				=> 'Modify the topic data before it is assigned to the template in MCP',
	'MCP_WARN_POST_AFTER'							=> 'Event for after warning a user for a post.',
	'MCP_WARN_POST_BEFORE'							=> 'Event for before warning a user for a post.',
	'MCP_WARN_USER_AFTER'							=> 'Event for after warning a user from MCP.',
	'MCP_WARN_USER_BEFORE'							=> 'Event for before warning a user from MCP.',
	'MEMBERLIST_PREPARE_PROFILE_DATA'				=> 'Preparing a user\'s data before displaying it in profile and memberlist',
	'MEMBERLIST_TEAM_MODIFY_QUERY'					=> 'Modify the query used to get the users for the team page',
	'MEMBERLIST_TEAM_MODIFY_TEMPLATE_VARS'			=> 'Modify the template vars for displaying the user in the groups on the teampage',
	'MEMBERLIST_VIEW_PROFILE'						=> 'Modify user data before we display the profile',
	'MESSAGE_PARSER_CHECK_MESSAGE'					=> 'This event can be used for additional message checks/cleanup before parsing',
	'MODIFY_BBCODE_INIT'							=> 'Event to modify the bbcode data for later parsing',
	'MODIFY_FORMAT_DISPLAY_TEXT_AFTER'				=> 'Event to modify the text after it is parsed',
	'MODIFY_MCP_MODULES_DISPLAY_OPTION'				=> 'This event allows you to set display option for custom MCP modules',
	'MODIFY_MODULE_ROW'								=> 'This event allows to modify parameters for building modules list',
	'MODIFY_POSTING_AUTH'							=> 'This event allows you to do extra auth checks and verify if the user',
	'MODIFY_POSTING_PARAMETERS'						=> 'This event allows you to alter the above parameters, such as submit and mode',
	'MODIFY_QUICKMOD_ACTIONS'						=> 'This event allows you to handle custom quickmod options',
	'MODIFY_QUICKMOD_OPTIONS'						=> 'This event allows you to add custom quickmod options',
	'MODIFY_SUBMIT_POST_DATA'						=> 'Modify the data for post submitting',
	'MODIFY_TEXT_FOR_DISPLAY_AFTER'					=> 'Use this event to modify the text after it is parsed',
	'MODIFY_TEXT_FOR_DISPLAY_BEFORE'				=> 'Use this event to modify the text before it is parsed',
	'MODIFY_TEXT_FOR_EDIT_AFTER'					=> 'Use this event to modify the text after it is decoded for editing',
	'MODIFY_TEXT_FOR_EDIT_BEFORE'					=> 'Use this event to modify the text before it is decoded for editing',
	'MODIFY_TEXT_FOR_STORAGE_AFTER'					=> 'Use this event to modify the text after it is prepared for storage',
	'MODIFY_TEXT_FOR_STORAGE_BEFORE'				=> 'Use this event to modify the text before it is prepared for storage',
	'MODIFY_UPLOADED_FILE'							=> 'Event to modify uploaded file before submit to the post',
	'MODIFY_USER_RANK'								=> 'Preparing a user\'s rank before displaying',
	'MODIFY_USERNAME_STRING'						=> 'Use this event to change the output of get_username_string()',
	'MODULE_AUTH'									=> 'Alter tokens for module authorisation check',
	'PAGE_FOOTER'									=> 'Execute code and/or overwrite page_footer()',
	'PAGE_FOOTER_AFTER'								=> 'Execute code and/or modify output before displaying the template.',
	'PAGE_HEADER'									=> 'Execute code and/or overwrite page_header()',
	'PAGE_HEADER_AFTER'								=> 'Execute code and/or overwrite _common_ template variables after they have been assigned.',
	'PAGINATION_GENERATE_PAGE_LINK'					=> 'Execute code and/or override generate_page_link()',
	'PARSE_ATTACHMENTS_MODIFY_TEMPLATE_DATA'		=> 'Use this event to modify the attachment template data.',
	'PERMISSIONS'									=> 'Allows to specify additional permission categories, types and permissions',
	'PHPBB_CONTENT_VISIBILITY_GET_FORUMS_VISIBILITY_BEFORE'		=> 'Allow changing the result of calling get_forums_visibility_sql',
	'PHPBB_CONTENT_VISIBILITY_GET_GLOBAL_VISIBILITY_BEFORE'		=> 'Allow changing the result of calling get_global_visibility_sql',
	'PHPBB_GENERATE_DEBUG_OUTPUT'					=> 'Modify debug output information',
	'POSTING_MODIFY_CANNOT_EDIT_CONDITIONS'			=> 'This event allows you to modify the conditions for the "cannot edit post" checks',
	'POSTING_MODIFY_MESSAGE_TEXT'					=> 'This event allows you to modify message text before parsing',
	'POSTING_MODIFY_SUBMISSION_ERRORS'				=> 'This event allows you to define errors before the post action is performed',
	'POSTING_MODIFY_SUBMIT_POST_AFTER'				=> 'This event allows you to define errors after the post action is performed',
	'POSTING_MODIFY_SUBMIT_POST_BEFORE'				=> 'This event allows you to define errors before the post action is performed',
	'POSTING_MODIFY_TEMPLATE_VARS'					=> 'This event allows you to modify template variables for the posting screen',
	'PRUNE_SQL'										=> 'Use this event to modify the SQL that selects topics to be pruned',
	'REPORT_POST_AUTH'								=> 'This event allows you to do extra auth checks and verify if the user',
	'SEARCH_GET_POSTS_DATA'							=> 'Event to modify the SQL query before the posts data is retrieved',
	'SEARCH_GET_TOPIC_DATA'							=> 'Event to modify the SQL query before the topic data is retrieved',
	'SEARCH_MODIFY_PARAM_BEFORE'					=> 'Event to modify the SQL parameters before pre-made searches',
	'SEARCH_MODIFY_ROWSET'							=> 'Modify the rowset data',
	'SEARCH_MODIFY_TPL_ARY'							=> 'Modify the topic data before it is assigned to the template',
	'SEARCH_RESULTS_MODIFY_SEARCH_TITLE'			=> 'Modify the title and/or load data for the search results page',
	'SESSION_SET_CUSTOM_BAN'						=> 'Event to set custom ban type',
	'SUBMIT_PM_AFTER'								=> 'Get PM message ID after submission to DB',
	'SUBMIT_PM_BEFORE'								=> 'Get all parts of the PM that are to be submited to the DB.',
	'SUBMIT_POST_END'								=> 'This event is used for performing actions directly after a post or topic',
	'SUBMIT_POST_MODIFY_SQL_DATA'					=> 'Modify sql query data for post submitting',
	'TOPIC_REVIEW_MODIFY_POST_LIST'					=> 'Event to modify the posts list for topic reviews',
	'TOPIC_REVIEW_MODIFY_ROW'						=> 'Event to modify the template data block for topic reviews',
	'UCP_ADD_ZEBRA'									=> 'Add users to friends/foes',
	'UCP_DELETE_COOKIES'							=> 'Event to save custom cookies from deletion',
	'UCP_DISPLAY_MODULE_BEFORE'						=> 'Use this event to enable and disable additional UCP modules',
	'UCP_PM_COMPOSE_COMPOSE_PM_BASIC_INFO_QUERY_BEFORE'		=> 'Alter sql query to get message for user to write the PM',
	'UCP_PM_COMPOSE_QUOTEPOST_QUERY_AFTER'			=> 'Get the result of querying for the post to be quoted in the pm message',
	'UCP_PM_VIEW_MESSSAGE'							=> 'Modify pm and sender data before it is assigned to the template',
	'UCP_PREFS_MODIFY_COMMON'						=> 'Modify UCP preferences data before the page load',
	'UCP_PREFS_PERSONAL_DATA'						=> 'Add UCP edit global settings data before they are assigned to the template or submitted',
	'UCP_PREFS_PERSONAL_UPDATE_DATA'				=> 'Update UCP edit global settings data on form submit',
	'UCP_PREFS_POST_DATA'							=> 'Add UCP edit posting defaults data before they are assigned to the template or submitted',
	'UCP_PREFS_POST_UPDATE_DATA'					=> 'Update UCP edit posting defaults data on form submit',
	'UCP_PREFS_VIEW_AFTER'							=> 'Run code before view form is displayed',
	'UCP_PREFS_VIEW_DATA'							=> 'Add UCP edit display options data before they are assigned to the template or submitted',
	'UCP_PREFS_VIEW_UPDATE_DATA'					=> 'Update UCP edit display options data on form submit',
	'UCP_PROFILE_INFO_MODIFY_SQL_ARY'				=> 'Modify profile data in UCP before submitting to the database',
	'UCP_PROFILE_MODIFY_PROFILE_INFO'				=> 'Modify user data on editing profile in UCP',
	'UCP_PROFILE_VALIDATE_PROFILE_INFO'				=> 'Validate user data on editing profile in UCP',
	'UCP_PROFILE_REG_DETAILS_DATA'					=> 'Modify user registration data on editing account settings in UCP',
	'UCP_PROFILE_REG_DETAILS_SQL_ARY'				=> 'Modify user registration data before submitting it to the database',
	'UCP_PROFILE_REG_DETAILS_VALIDATE'				=> 'Validate user data on editing registration data in UCP',
	'UCP_REGISTER_DATA_AFTER'						=> 'Check UCP registration data after they are submitted',
	'UCP_REGISTER_DATA_BEFORE'						=> 'Add UCP register data before they are assigned to the template or submitted',
	'UCP_REGISTER_USER_ROW_AFTER'					=> 'Add into $user_row before user_add',
	'UCP_REMOVE_ZEBRA'								=> 'Remove users from friends/foes',
	'UPDATE_USERNAME'								=> 'Update a username when it is changed',
	'USER_ADD_AFTER'								=> 'Event that returns user id, user detals and user CPF of newly registared user',
	'USER_ADD_MODIFY_DATA'							=> 'Use this event to modify the values to be inserted when a user is added',
	'USER_SET_DEFAULT_GROUP'						=> 'Event when the default group is set for an array of users',
	'USER_SETUP'									=> 'Event to load language files and modify user data on every page',
	'VALIDATE_CONFIG_VARIABLE'						=> 'Validate a config value',
	'VIEWFORUM_GET_SHADOWTOPIC_DATA'				=> 'Event to modify the SQL query before the shadowtopic data is retrieved',
	'VIEWFORUM_GET_TOPIC_DATA'						=> 'Event to modify the SQL query before the topic data is retrieved',
	'VIEWFORUM_GET_TOPIC_IDS_DATA'					=> 'Event to modify the SQL query before the topic ids data is retrieved',
	'VIEWFORUM_MODIFY_SORT_DATA_SQL'				=> 'Modify the sort data SQL query for getting additional fields if needed',
	'VIEWFORUM_MODIFY_TOPICROW'						=> 'Modify the topic data before it is assigned to the template',
	'VIEWFORUM_MODIFY_TOPICS_DATA'					=> 'Modify topics data before we display the viewforum page',
	'VIEWFORUM_TOPIC_ROW_AFTER'						=> 'Event after the topic data has been assigned to the template',
	'VIEWONLINE_MODIFY_SQL'							=> 'Modify the SQL query for getting the user data to display viewonline list',
	'VIEWONLINE_MODIFY_USER_ROW'					=> 'Modify viewonline template data before it is displayed in the list',
	'VIEWONLINE_OVERWRITE_LOCATION'					=> 'Overwrite the location\'s name and URL, which are displayed in the list',
	'VIEWTOPIC_ADD_QUICKMOD_OPTION_BEFORE'			=> 'Event to modify data in the quickmod_array before it gets sent to the',
	'VIEWTOPIC_ASSIGN_TEMPLATE_VARS_BEFORE'			=> 'Event to modify data before template variables are being assigned',
	'VIEWTOPIC_BEFORE_F_READ_CHECK'					=> 'Event to apply extra permissions and to override original phpBB\'s f_read permission and forum password check',
	'VIEWTOPIC_CACHE_GUEST_DATA'					=> 'Modify the guest users data displayed with the posts',
	'VIEWTOPIC_CACHE_USER_DATA'						=> 'Modify the users data displayed with their posts',
	'VIEWTOPIC_GET_POST_DATA'						=> 'Event to modify the SQL query before the post and poster data is retrieved',
	'VIEWTOPIC_MODIFY_PAGE_TITLE'					=> 'You can use this event to modify the page title of the viewtopic page',
	'VIEWTOPIC_MODIFY_POST_ACTION_CONDITIONS'		=> 'This event allows you to modify the conditions for the "can edit post" and "can delete post" checks',
	'VIEWTOPIC_MODIFY_POST_DATA'					=> 'Event to modify the post, poster and attachment data before assigning the posts',
	'VIEWTOPIC_MODIFY_POST_ROW'						=> 'Modify the posts template block',
	'VIEWTOPIC_POST_ROW_AFTER'						=> 'Event after the post data has been assigned to the template',
	'VIEWTOPIC_POST_ROWSET_DATA'					=> 'Modify the post rowset containing data to be displayed with posts',

	'ACP_EMAIL_DISPLAY'								=> 'Modify custom email template data before we display the form',
	'ACP_USERS_MODIFY_PROFILE'						=> 'Modify user data on editing profile in ACP',
	'ACP_USERS_PROFILE_MODIFY_SQL_ARY'				=> 'Modify profile data in ACP before submitting to the database',
	'ACP_PROFILE_CREATE_EDIT_AFTER'					=> 'Event to add template variables for new profile field table fields',
	'ACP_PROFILE_CREATE_EDIT_INIT'					=> 'Event to add initialization for new profile field table fields',
	'ACP_PROFILE_CREATE_EDIT_SAVE_BEFORE'			=> 'Event to modify profile field configuration data before saving to database',
	'AVATAR_DRIVER_UPLOAD_DELETE_BEFORE'			=> 'Before deleting an existing avatar',
	'AVATAR_DRIVER_UPLOAD_MOVE_FILE_BEFORE'			=> 'Before moving new file in place (and eventually overwriting the existing avatar with the newly uploaded avatar) ',
	'DELETE_FORUM_CONTENT_BEFORE_QUERY'				=> 'Perform additional actions before forum content deletion',
	'DOWNLOAD_FILE_SEND_TO_BROWSER_BEFORE'			=> 'Event to modify data before sending file to browser',
	'MCP_FRONT_QUEUE_UNAPPROVED_TOTAL_BEFORE'		=> 'Allow altering the query to get the number of unapproved posts',
	'MCP_GLOBAL_F_READ_AUTH_AFTER'					=> 'Allow applying additional permissions to MCP access besides f_read',
	'MCP_REPORTS_REPORT_DETAILS_QUERY_AFTER'		=> 'Allow changing the data obtained from the user-submitted report',
	'MCP_REPORTS_REPORT_DETAILS_QUERY_BEFORE'		=> 'Allow changing the query to obtain the user-submitted report',
	'SEARCH_MYSQL_AUTHOR_QUERY_BEFORE'				=> 'Allow changing the query used to search for posts by author in fulltext_mysql',
	'SEARCH_NATIVE_AUTHOR_COUNT_QUERY_BEFORE'		=> 'Allow changing the query used to search for posts by author in fulltext_native',
	'SEARCH_POSTGRES_AUTHOR_COUNT_QUERY_BEFORE'		=> 'Allow changing the query used to search for posts by author in fulltext_postgres',
	'SEARCH_NATIVE_KEYWORDS_COUNT_QUERY_BEFORE'		=> 'Allow changing the query used for counting for posts using fulltext_native',
	'SEARCH_MYSQL_KEYWORDS_MAIN_QUERY_BEFORE'		=> 'Allow changing the query used to search for posts using fulltext_mysql',
	'SEARCH_POSTGRES_KEYWORDS_MAIN_QUERY_BEFORE'	=> 'Allow changing the query used to search for posts using fulltext_postgres',
	'PHPBB_CONTENT_VISIBILITY_GET_VISIBILITY_SQL_BEFORE'	=> 'Allow changing the result of calling get_visibility_sql',
	'NOTIFICATION_MANAGER_ADD_NOTIFICATIONS'		=> 'Allow filtering the notify_users array for a notification that is about to be sent',
	'UCP_REGISTER_AGREEMENT'						=> 'Allows to modify the agreements',
	'MCP_FRONT_REPORTS_COUNT_QUERY_BEFORE'			=> 'Alter sql query to count the number of reported posts',
	'GET_UNREAD_TOPICS_MODIFY_SQL'					=> 'Change SQL query for fetching unread topics data',
	'USER_ACTIVE_FLIP_AFTER'						=> 'Perform additional actions after the users have been activated / deactivated',
	'USER_ACTIVE_FLIP_BEFORE'						=> 'Check or modify activated / deactivated users data before submitting it to the database',
	'MCP_POST_ADDITIONAL_OPTIONS'					=> 'Add content within the list of post moderation actions',
	'MCP_POST_TEMPLATE_DATA'						=> 'Event to add/modify MCP post template data',
	'ACP_USERS_PROFILE_VALIDATE'					=> 'Validate profile data in ACP before submitting to the database',
	'VIEWTOPIC_MODIFY_POLL_TEMPLATE_DATA'			=> 'Event to add/modify poll template data ',
	'VIEWTOPIC_MODIFY_POLL_DATA'					=> 'Event to manipulate the poll data ',
	'GET_AVATAR_AFTER'								=> 'Event to modify HTML &lt;img&gt; tag of avatar',
	'GENERATE_PROFILE_FIELDS_TEMPLATE_HEADLINES'	=> 'Event to modify template headlines of the generated profile fields',
	'GENERATE_FORUM_NAV'							=> 'Event to modify the navlinks text ',
	'MCP_TOPIC_REVIEW_MODIFY_ROW'					=> 'Event to modify the template data block for topic reviews in the MCP',
	'MCP_SORTING_QUERY_BEFORE'						=> 'This event allows you to control the SQL query used to get the total number',
	'MCP_FORUM_VIEW_BEFORE'							=> 'Get some data in order to execute other actions',
	'MODIFY_FORMAT_DISPLAY_TEXT_BEFORE'				=> 'Event to modify the text before it is parsed',
	'DISPLAY_FORUMS_BEFORE'							=> 'Event to perform additional actions before the forum list is being generated',
	'BBCODE_SECOND_PASS_BY_EXTENSION'				=> 'Event to perform bbcode second pass with',
	'SESSION_CREATE_AFTER'							=> 'Event to send new session data to extension',
	'SESSION_GC_AFTER'								=> 'Event to trigger extension on session_gc ',
	'SESSION_KILL_AFTER'							=> 'Event to send session kill information to extension',
	'DELETE_TOPICS_AFTER_QUERY'						=> 'Perform additional actions after topic(s) deletion ',
	'DELETE_TOPICS_BEFORE_QUERY'					=> 'Perform additional actions before topic(s) deletion',
	'APPROVE_POSTS_AFTER'							=> 'Perform additional actions during post(s) approval',
	'APPROVE_TOPICS_AFTER'							=> 'Perform additional actions during topics(s) approval',
	'MARKREAD_BEFORE'								=> 'This event is used for performing actions directly before marking forums',
	'USER_SETUP_AFTER'								=> 'Execute code at the end of user setup',
	'VALIDATE_BBCODE_BY_EXTENSION'					=> 'Event to validate bbcode with the custom validating methods',
	'UCP_PM_COMPOSE_MODIFY_DATA'					=> 'Modify the default vars before composing a PM',
	'GET_LOGS_MAIN_QUERY_BEFORE'					=> 'Modify the query to obtain the logs data',
	'VIEWONLINE_MODIFY_FORUM_DATA_SQL'				=> 'Modify the forum data SQL query for getting additional fields if needed',
	'MOVE_TOPICS_BEFORE_QUERY'						=> 'Perform additional actions before topics move',
	'DISAPPROVE_POSTS_AFTER'						=> 'Perform additional actions during post(s) disapproval',
	'MCP_CHANGE_POSTER_AFTER'						=> 'This event allows you to perform additional tasks after changing a post\'s poster',
	'UCP_ACTIVATE_AFTER'							=> 'This event can be used to modify data after user account\'s activation',
	'AUTH_LOGIN_SESSION_CREATE_BEFORE'				=> 'Event is triggered after checking for valid username and password, and before the actual session creation',
	'DELETE_ATTACHMENTS_BEFORE'						=> 'Perform additional actions before attachment(s) deletion',
	'DELETE_ATTACHMENTS_COLLECT_DATA_BEFORE'		=> 'Perform additional actions before collecting data for attachment(s) deletion',
	'DELETE_ATTACHMENTS_FROM_DATABASE_AFTER'		=> 'Perform additional actions after attachment(s) deletion from the database',
	'DELETE_ATTACHMENTS_FROM_FILESYSTEM_AFTER'		=> 'Perform additional actions after attachment(s) deletion from the filesystem',
	'DELETE_POSTS_IN_TRANSACTION_BEFORE'			=> 'Perform additional actions during post(s) deletion before running the queries',
	'GROUP_ADD_USER_AFTER'							=> 'Event after users are added to a group',
	'GROUP_DELETE_USER_AFTER'						=> 'Event after users are removed from a group',
	'INDEX_MODIFY_BIRTHDAYS_LIST'					=> 'Event to modify the birthdays list',
	'INDEX_MODIFY_BIRTHDAYS_SQL'					=> 'Event to modify the SQL query to get birthdays data',
	'MCP_LOCK_UNLOCK_AFTER'							=> 'Perform additional actions after locking/unlocking posts/topics',
	'MCP_TOPIC_MODIFY_POST_DATA'					=> 'Event to modify the post data for the MCP topic review before assigning the posts',
	'MEMBERLIST_MEMBERROW_BEFORE'					=> 'Modify list of users before member row is created',
	'MEMBERLIST_MODIFY_IP_SEARCH_SQL_QUERY'			=> 'Modify sql query for members search by ip address / hostname',
	'MEMBERLIST_MODIFY_SQL_QUERY_DATA'				=> 'Modify sql query data for members search',
	'MOVE_POSTS_AFTER'								=> 'Perform additional actions after moving posts',
	'MOVE_POSTS_BEFORE'								=> 'Perform additional actions before moving posts',
	'OBTAIN_USERS_ONLINE_STRING_MODIFY'				=> 'Modify online userlist data',
	'OBTAIN_USERS_ONLINE_STRING_SQL'				=> 'Modify SQL query to obtain online users data',
	'SEARCH_MODIFY_PARAM_AFTER'						=> 'Event to modify data after pre-made searches',
	'SEARCH_MODIFY_URL_PARAMETERS'					=> 'Event to add or modify search URL parameters',
	'SEARCH_MYSQL_BY_AUTHOR_MODIFY_SEARCH_KEY'		=> 'Allow changing the search_key for cached results',
	'SEARCH_MYSQL_BY_KEYWORD_MODIFY_SEARCH_KEY'		=> 'Allow changing the search_key for cached results',
	'SEARCH_NATIVE_BY_AUTHOR_MODIFY_SEARCH_KEY'		=> 'Allow changing the search_key for cached results',
	'SEARCH_NATIVE_BY_KEYWORD_MODIFY_SEARCH_KEY'	=> 'Allow changing the search_key for cached results',
	'SEARCH_POSTGRES_BY_AUTHOR_MODIFY_SEARCH_KEY'	=> 'Allow changing the search_key for cached results',
	'SEARCH_POSTGRES_BY_KEYWORD_MODIFY_SEARCH_KEY'	=> 'Allow changing the search_key for cached results',
	'SEARCH_SPHINX_KEYWORDS_MODIFY_OPTIONS'			=> 'Allow modifying the Sphinx search options',
	'SEARCH_SPHINX_MODIFY_CONFIG_DATA'				=> 'Allow adding/changing the Sphinx configuration data',
	'UPDATE_SESSION_AFTER'							=> 'Event to send update session information to extension',
	'ACP_STYLES_ACTION_BEFORE'						=> 'Run code before ACP styles action execution',
	'GET_GRAVATAR_URL_AFTER'						=> 'Modify gravatar url',

	// Template events
	'FORUMLIST_BODY_CATEGORY_HEADER_AFTER'			=> 'Add content after the header of the category on the forum list.',
	'FORUMLIST_BODY_CATEGORY_HEADER_BEFORE'			=> 'Add content before the header of the category on the forum list.',
	'FORUMLIST_BODY_FORUM_ROW_AFTER'				=> 'Add content after the forum list item',
	'FORUMLIST_BODY_FORUM_ROW_APPEND'				=> 'Add content at the start of the forum list item',
	'FORUMLIST_BODY_FORUM_ROW_BEFORE'				=> 'Add content before the forum list item.',
	'FORUMLIST_BODY_FORUM_ROW_PREPEND'				=> 'Add content at the end of the forum list item.',
	'FORUMLIST_BODY_LAST_POST_TITLE_PREPEND'		=> 'Add content before the post title of the latest post in a forum on the forum list.',
	'FORUMLIST_BODY_SUBFORUMS_AFTER'				=> 'Add content after the list of subforums (if any) for each forum on the forum list.',
	'FORUMLIST_BODY_SUBFORUMS_BEFORE'				=> 'Add content before the list of subforums (if any) for each forum on the forum list.',
	'FORUMLIST_BODY_LAST_ROW_AFTER'					=> 'Add content after the very last row of the forum list.',
	'INDEX_BODY_BLOCK_BIRTHDAY_APPEND'				=> 'Append content to the birthday list on the Board index',
	'INDEX_BODY_BLOCK_BIRTHDAY_PREPEND'				=> 'Prepend content to the birthday list on the Board index',
	'INDEX_BODY_BLOCK_ONLINE_APPEND'				=> 'Append content to the online list on the Board index',
	'INDEX_BODY_BLOCK_ONLINE_PREPEND'				=> 'Prepend content to the online list on the Board index',
	'INDEX_BODY_BLOCK_STATS_APPEND'					=> 'Append content to the statistics list on the Board index',
	'INDEX_BODY_BLOCK_STATS_PREPEND'				=> 'Prepend content to the statistics list on the Board index',
	'INDEX_BODY_FORUMLIST_BODY_AFTER'				=> 'Add content after the forum list body on the index page',
	'INDEX_BODY_MARKFORUMS_AFTER'					=> 'Add content after the mark-read link above the forum list on Board index',
	'INDEX_BODY_MARKFORUMS_BEFORE'					=> 'Add content before the mark-read link above the forum list on Board index',
	'INDEX_BODY_STAT_BLOCKS_AFTER'					=> 'Add new statistic blocks below the Who Is Online and Board Statistics blocks',
	'INDEX_BODY_STAT_BLOCKS_BEFORE'					=> 'Add new statistic blocks above the Who Is Online and Board Statistics blocks',
	'MCP_BAN_FIELDS_AFTER'							=> 'Add additional fields to the ban form in MCP',
	'MCP_BAN_FIELDS_BEFORE'							=> 'Add additional fields to the ban form in MCP',
	'MCP_BAN_UNBAN_AFTER'							=> 'Add additional fields to the unban form in MCP',
	'MCP_BAN_UNBAN_BEFORE'							=> 'Add additional fields to the unban form in MCP',
	'MCP_FRONT_LATEST_LOGS_AFTER'					=> 'Add content after latest logs list',
	'MCP_FRONT_LATEST_LOGS_BEFORE'					=> 'Add content before latest logs list',
	'MCP_FRONT_LATEST_REPORTED_BEFORE'				=> 'Add content before latest reported posts list',
	'MCP_FRONT_LATEST_REPORTED_PMS_BEFORE'			=> 'Add content before latest reported private messages list',
	'MCP_FRONT_LATEST_UNAPPROVED_BEFORE'			=> 'Add content before latest unapproved posts list',
	'MEMBERLIST_BODY_USERNAME_APPEND'				=> 'Add information after every username in the memberlist. Works in all display modes (leader, group and normal memberlist).',
	'MEMBERLIST_BODY_USERNAME_PREPEND'				=> 'Add information before every username in the memberlist. Works in all display modes (leader, group and normal memberlist).',
	'MEMBERLIST_SEARCH_FIELDS_AFTER'				=> 'Add information after the search fields column.',
	'MEMBERLIST_SEARCH_FIELDS_BEFORE'				=> 'Add information before the search fields column.',
	'MEMBERLIST_SEARCH_SORTING_OPTIONS_BEFORE'		=> 'Add information before the search sorting options field.',
	'MEMBERLIST_VIEW_CONTACT_AFTER'					=> 'Add content after the user contact part of any user profile',
	'MEMBERLIST_VIEW_CONTACT_BEFORE'				=> 'Add content before the user contact part of any user profile',
	'MEMBERLIST_VIEW_CONTACT_CUSTOM_FIELDS_AFTER'	=> 'Add content after the user contact related custom fields',
	'MEMBERLIST_VIEW_CONTACT_CUSTOM_FIELDS_BEFORE'	=> 'Add content before the user contact related custom fields',
	'MEMBERLIST_VIEW_CONTENT_APPEND'				=> 'Add custom content to the user profile view after the main content',
	'MEMBERLIST_VIEW_CONTENT_PREPEND'				=> 'Add custom content to the user profile view before the main content',
	'MEMBERLIST_VIEW_NON_CONTACT_CUSTOM_FIELDS_AFTER'	=> 'Add content after the user not contact related custom fields',
	'MEMBERLIST_VIEW_NON_CONTACT_CUSTOM_FIELDS_BEFORE'	=> 'Add content before the user not contact related custom fields',
	'MEMBERLIST_VIEW_USER_STATISTICS_AFTER'			=> 'Add entries after the user statistics part of any user profile',
	'MEMBERLIST_VIEW_USER_STATISTICS_BEFORE'		=> 'Add entries before the user statistics part of any user profile',
	'MEMBERLIST_VIEW_ZEBRA_AFTER'					=> 'Add content after the user friends/foes links',
	'MCP_WARN_POST_ADD_WARNING_FIELD_AFTER'			=> 'Add content during warning for a post - after add warning field.',
	'MEMBERLIST_VIEW_ZEBRA_BEFORE'					=> 'Add content before the user friends/foes links',
	'MCP_WARN_POST_ADD_WARNING_FIELD_BEFORE'		=> 'Add content during warning for a post - before add warning field.',
	'MCP_WARN_USER_ADD_WARNING_FIELD_AFTER'			=> 'Add content during warning a user - after add warning field.',
	'MCP_WARN_USER_ADD_WARNING_FIELD_BEFORE'		=> 'Add content during warning a user - before add warning field.',
	'NAVBAR_HEADER_LOGGED_OUT_CONTENT'				=> 'Add text and HTML in place of the username when not logged in.',
	'NAVBAR_HEADER_PROFILE_LIST_AFTER'				=> 'Add links to the bottom of the profile drop-down menu in the header navbar',
	'NAVBAR_HEADER_PROFILE_LIST_BEFORE'				=> 'Add links to the top of the profile drop-down menu in the header navbar',
	'NAVBAR_HEADER_QUICK_LINKS_AFTER'				=> 'Add links to the bottom of the quick-links drop-down menu in the header',
	'NAVBAR_HEADER_QUICK_LINKS_BEFORE'				=> 'Add links to the top of the quick-links drop-down menu in the header',
	'NAVBAR_HEADER_USER_PROFILE_APPEND'				=> 'Add links to the right of the user drop down area',
	'NAVBAR_HEADER_USER_PROFILE_PREPEND'			=> 'Add links to the left of the notification area',
	'NAVBAR_HEADER_USERNAME_APPEND'					=> 'Add text and HTMl after the username shown in the navbar.',
	'NAVBAR_HEADER_USERNAME_PREPEND'				=> 'Add text and HTMl before the username shown in the navbar.',
	'OVERALL_FOOTER_AFTER'							=> 'Add content at the end of the file, directly prior to the `&lt;/body&gt;&gt;` tag',
	'OVERALL_FOOTER_BODY_AFTER'						=> 'Add content before the `&lt;/body&gt;&gt;` tag but after the $SCRIPTS var, i.e. after the js scripts have been loaded',
	'OVERALL_FOOTER_BREADCRUMB_APPEND'				=> 'Add links to the list of breadcrumbs in the footer',
	'OVERALL_FOOTER_BREADCRUMB_PREPEND'				=> 'Add links to the list of breadcrumbs in the footer (after site-home, but before board-index)',
	'OVERALL_FOOTER_CONTENT_AFTER'					=> 'Add content on all pages after the main content, before the footer',
	'OVERALL_FOOTER_COPYRIGHT_APPEND'				=> 'Add content after the copyright line (no new line by default), before the ACP link',
	'OVERALL_FOOTER_COPYRIGHT_PREPEND'				=> 'Add content before the copyright line',
	'OVERALL_FOOTER_PAGE_BODY_AFTER'				=> 'Add content after the page-body, but before the footer',
	'OVERALL_FOOTER_TEAMLINK_AFTER'					=> 'Add contents after the team-link in the footer',
	'OVERALL_FOOTER_TEAMLINK_BEFORE'				=> 'Add contents before the team-link in the footer',
	'OVERALL_FOOTER_TIMEZONE_AFTER'					=> 'Add content to the navbar in the page footer, after "Timezone"',
	'OVERALL_FOOTER_TIMEZONE_BEFORE'				=> 'Add content to the navbar in the page footer, before "Timezone"',
	'OVERALL_HEADER_BODY_BEFORE'					=> 'Add content to the header body',
	'OVERALL_HEADER_BREADCRUMB_APPEND'				=> 'Add links to the list of breadcrumbs in the header',
	'OVERALL_HEADER_BREADCRUMB_PREPEND'				=> 'Add links to the list of breadcrumbs in the header (after site-home, but before board-index)',
	'OVERALL_HEADER_BREADCRUMBS_AFTER'				=> 'Add content after the breadcrumbs (outside of the breadcrumbs container)',
	'OVERALL_HEADER_BREADCRUMBS_BEFORE'				=> 'Add content before the breadcrumbs (outside of the breadcrumbs container)',
	'OVERALL_HEADER_CONTENT_BEFORE'					=> 'Add content on all pages before the main content, after the header',
	'OVERALL_HEADER_HEAD_APPEND'					=> 'Add asset calls directly before the `&lt;/head&gt;&gt;` tag',
	'OVERALL_HEADER_NAVIGATION_APPEND'				=> 'Add links after the navigation links in the header',
	'OVERALL_HEADER_NAVIGATION_PREPEND'				=> 'Add links before the navigation links in the header',
	'OVERALL_HEADER_NAVLINK_APPEND'					=> 'Add content after each individual navlink (breadcrumb)',
	'OVERALL_HEADER_NAVLINK_PREPEND'				=> 'Add content before each individual navlink (breadcrumb)',
	'OVERALL_HEADER_PAGE_BODY_BEFORE'				=> 'Add content after the page-header, but before the page-body',
	'OVERALL_HEADER_STYLESHEETS_AFTER'				=> 'Add asset calls after stylesheets within the `&lt;/head&gt;&gt;` tag. Note that INCLUDECSS will not work with this event.',
	'POSTING_EDITOR_BUTTONS_AFTER'					=> 'Add content after the BBCode posting buttons',
	'POSTING_EDITOR_BUTTONS_BEFORE'					=> 'Add content before the BBCode posting buttons',
	'POSTING_EDITOR_BUTTONS_CUSTOM_TAGS_BEFORE'		=> 'Add content inside the BBCode posting buttons and before the customs BBCode',
	'POSTING_EDITOR_MESSAGE_AFTER'					=> 'Add field (e.g. textbox) to the posting screen after the message',
	'POSTING_EDITOR_MESSAGE_BEFORE'					=> 'Add field (e.g. textbox) to the posting screen before the message',
	'POSTING_EDITOR_OPTIONS_PREPEND'				=> 'Add posting options on the posting screen',
	'POSTING_EDITOR_SUBJECT_AFTER'					=> 'Add field (e.g. textbox) to the posting screen after the subject',
	'POSTING_EDITOR_SUBJECT_BEFORE'					=> 'Add field (e.g. textbox) to the posting screen before the subject',
	'POSTING_PM_HEADER_FIND_USERNAME_AFTER'			=> 'Add content after the find username link on composing pm',
	'POSTING_PM_HEADER_FIND_USERNAME_BEFORE'		=> 'Add content before the find username link on composing pm',
	'QUICKREPLY_EDITOR_PANEL_AFTER'					=> 'Add content after the quick reply panel (but inside the form)',
	'QUICKREPLY_EDITOR_PANEL_BEFORE'				=> 'Add content before the quick reply panel (but inside the form)',
	'QUICKREPLY_EDITOR_MESSAGE_AFTER'				=> 'Add content after the quick reply textbox',
	'QUICKREPLY_EDITOR_MESSAGE_BEFORE'				=> 'Add content before the quick reply textbox',
	'SEARCH_RESULTS_POST_AFTER'						=> 'Add data after search result posts',
	'SEARCH_RESULTS_POST_BEFORE'					=> 'Add data before search result posts',
	'SEARCH_RESULTS_POSTPROFILE_AFTER'				=> 'Add content after the post author and stats in search results (posts view mode)',
	'SEARCH_RESULTS_POSTPROFILE_BEFORE'				=> 'Add content directly before the post author in search results (posts view mode)',
	'SEARCH_RESULTS_TOPIC_AFTER'					=> 'Add data after search result topics',
	'SEARCH_RESULTS_TOPIC_BEFORE'					=> 'Add data before search result topics',
	'SIMPLE_FOOTER_AFTER'							=> 'Add content directly prior to the `&lt;/body&gt;&gt;` tag of the simple footer',
	'SIMPLE_HEADER_BODY_BEFORE'						=> 'Add content to the header body',
	'SIMPLE_HEADER_HEAD_APPEND'						=> 'Add asset calls directly before the `&lt;/head&gt;&gt;` tag',
	'SIMPLE_HEADER_STYLESHEETS_AFTER'				=> 'Add asset calls after stylesheets within the `&lt;/head&gt;&gt;` tag. Note that INCLUDECSS will not work with this event.',
	'TOPICLIST_ROW_PREPEND'							=> 'Add content into topic rows (inside the elements containing topic titles)',
	'TOPICLIST_ROW_APPEND'							=> 'Add content into topic rows (inside the elements containing topic titles)',
	'UCP_AGREEMENT_TERMS_AFTER'						=> 'Add content after the terms of agreement text at user registration',
	'UCP_AGREEMENT_TERMS_BEFORE'					=> 'Add content before the terms of agreement text at user registration',
	'UCP_PM_VIEWMESSAGE_AVATAR_AFTER'				=> 'Add content right after the avatar when viewing a private message',
	'UCP_PM_VIEWMESSAGE_AVATAR_BEFORE'				=> 'Add content right before the avatar when viewing a private message',
	'UCP_PM_VIEWMESSAGE_CONTACT_FIELDS_AFTER'		=> 'Add data after the contact fields on the user profile when viewing a private message',
	'UCP_PM_VIEWMESSAGE_CONTACT_FIELDS_BEFORE'		=> 'Add data before the contact fields on the user profile when viewing a private message',
	'UCP_PM_VIEWMESSAGE_CUSTOM_FIELDS_AFTER'		=> 'Add data after the custom fields on the user profile when viewing a private message',
	'UCP_PM_VIEWMESSAGE_CUSTOM_FIELDS_BEFORE'		=> 'Add data before the custom fields on the user profile when viewing a private message',
	'UCP_PM_VIEWMESSAGE_POST_BUTTONS_AFTER'			=> 'Add post button to private messages (next to edit, quote etc), at the end of the list.',
	'UCP_PM_VIEWMESSAGE_POST_BUTTONS_BEFORE'		=> 'Add post button to private messages (next to edit, quote etc), at the start of the list.',
	'UCP_PM_VIEWMESSAGE_PRINT_HEAD_APPEND'			=> 'Add asset calls directly before the `&lt;/head&gt;&gt;` tag of the Print PM screen',
	'UCP_PREFS_PERSONAL_PREPEND'					=> 'Add user options to the top of the Edit Global Settings block',
	'UCP_PREFS_PERSONAL_APPEND'						=> 'Add user options to the bottom of the Edit Global Settings block',
	'UCP_PREFS_POST_PREPEND'						=> 'Add user options to the top of the Edit Posting Defaults block',
	'UCP_PREFS_POST_APPEND'							=> 'Add user options to the bottom of the Edit Posting Defaults block',
	'UCP_PREFS_VIEW_RADIO_BUTTONS_PREPEND'			=> 'Add options to the top of the radio buttons block of the Edit Display Options screen',
	'UCP_PREFS_VIEW_RADIO_BUTTONS_APPEND'			=> 'Add options to the bottom of the radio buttons block of the Edit Display Options screen',
	'UCP_PREFS_VIEW_SELECT_MENU_PREPEND'			=> 'Add options to the top of the drop-down lists block of the Edit Display Options screen',
	'UCP_PREFS_VIEW_SELECT_MENU_APPEND'				=> 'Add options to the bottom of the drop-down lists block of the Edit Display Options screen',
	'UCP_REGISTER_CREDENTIALS_BEFORE'				=> 'Add options in registration page fieldset - before first field.',
	'UCP_REGISTER_PROFILE_FIELDS_AFTER'				=> 'Add options in registration page fieldset - after last field.',
	'UCP_REGISTER_CREDENTIALS_AFTER'				=> 'Add options in registration page fieldset - after password field.',
	'UCP_REGISTER_OPTIONS_BEFORE'					=> 'Add options in registration page fieldset - before language selector.',
	'UCP_REGISTER_PROFILE_FIELDS_BEFORE'			=> 'Add options in registration page fieldset - before profile fields.',
	'UCP_FRIEND_LIST_BEFORE'						=> 'Add optional elements before list of friends in UCP',
	'UCP_FRIEND_LIST_AFTER'							=> 'Add optional elements after list of friends in UCP',
	'VIEWFORUM_BUTTONS_BOTTOM_BEFORE'				=> 'Add buttons before New Topic button on the bottom of the topic\'s list',
	'VIEWFORUM_BUTTONS_BOTTOM_AFTER'				=> 'Add buttons after New Topic button on the bottom of the topic\'s list',
	'VIEWFORUM_BUTTONS_TOP_BEFORE'					=> 'Add buttons before New Topic button on the top of the topic\'s list',
	'VIEWFORUM_BUTTONS_TOP_AFTER'					=> 'Add buttons after New Topic button on the top of the topic\'s list',
	'VIEWTOPIC_BUTTONS_BOTTOM_BEFORE'				=> 'Add buttons before Post Reply button on the bottom of the posts\'s list',
	'VIEWTOPIC_BUTTONS_BOTTOM_AFTER'				=> 'Add buttons after Post Reply button on the bottom of the posts\'s list',
	'VIEWTOPIC_BUTTONS_TOP_BEFORE'					=> 'Add buttons before Post Reply button on the top of the posts\'s list',
	'VIEWTOPIC_BUTTONS_TOP_AFTER'					=> 'Add buttons after Post Reply button on the top of the posts\'s list',
	'VIEWFORUM_FORUM_NAME_APPEND'					=> 'Add content directly after the forum name link on the View forum screen',
	'VIEWFORUM_FORUM_NAME_PREPEND'					=> 'Add content directly before the forum name link on the View forum screen',
	'VIEWTOPIC_PRINT_HEAD_APPEND'					=> 'Add asset calls directly before the `&lt;/head&gt;&gt;` tag of the Print Topic screen',
	'VIEWTOPIC_BODY_AVATAR_AFTER'					=> 'Add content right after the avatar when viewing topics',
	'VIEWTOPIC_BODY_AVATAR_BEFORE'					=> 'Add content right before the avatar when viewing topics',
	'VIEWTOPIC_BODY_CONTACT_FIELDS_AFTER'			=> 'Add data after the contact fields on the user profile when viewing a post',
	'VIEWTOPIC_BODY_CONTACT_FIELDS_BEFORE'			=> 'Add data before the contact fields on the user profile when viewing a post',
	'VIEWTOPIC_BODY_FOOTER_BEFORE'					=> 'Add content to the bottom of the View topic screen below the posts and quick reply, directly before the jumpbox in Prosilver, breadcrumbs in Subsilver2.',
	'VIEWTOPIC_BODY_POLL_OPTION_AFTER'				=> 'Add content after the poll option the list.',
	'VIEWTOPIC_BODY_POLL_OPTION_BEFORE'				=> 'Add content before the poll option the list.',
	'VIEWTOPIC_BODY_POLL_QUESTION_APPEND'			=> 'Add content directly after the poll question on the View topic screen',
	'VIEWTOPIC_BODY_POLL_QUESTION_PREPEND'			=> 'Add content directly before the poll question on the View topic screen',
	'VIEWTOPIC_BODY_POST_AUTHOR_AFTER'				=> 'Add content directly after the post author on the view topic screen',
	'VIEWTOPIC_BODY_POST_AUTHOR_BEFORE'				=> 'Add content directly before the post author on the view topic screen',
	'VIEWTOPIC_BODY_POST_BUTTONS_AFTER'				=> 'Add post button to posts (next to edit, quote etc), at the end of the list.',
	'VIEWTOPIC_BODY_POST_BUTTONS_BEFORE'			=> 'Add post button to posts (next to edit, quote etc), at the start of the list.',
	'VIEWTOPIC_BODY_POSTROW_CUSTOM_FIELDS_AFTER'	=> 'Add data after the custom fields on the user profile when viewing a post',
	'VIEWTOPIC_BODY_POSTROW_CUSTOM_FIELDS_BEFORE'	=> 'Add data before the custom fields on the user profile when viewing a post',
	'VIEWTOPIC_BODY_POSTROW_POST_AFTER'				=> 'Add data after posts',
	'VIEWTOPIC_BODY_POSTROW_POST_BEFORE'			=> 'Add data before posts',
	'VIEWTOPIC_BODY_POSTROW_POST_CONTENT_FOOTER'	=> 'Add data at the end of the posts.',
	'VIEWTOPIC_BODY_POSTROW_POST_NOTICES_AFTER'		=> 'Add posts specific custom notices at the notices bottom.',
	'VIEWTOPIC_BODY_POSTROW_POST_NOTICES_BEFORE'	=> 'Add posts specific custom notices at the notices top.',
	'VIEWTOPIC_BODY_TOPIC_ACTIONS_BEFORE'			=> 'Add data before the topic actions buttons (after the posts sorting options)',
	'VIEWTOPIC_TOPIC_TITLE_APPEND'					=> 'Add content directly after the topic title link on the View topic screen',
	'VIEWTOPIC_TOPIC_TITLE_PREPEND'					=> 'Add content directly before the topic title link on the View topic screen',
	'VIEWTOPIC_TOPIC_TOOLS_AFTER'					=> 'Add a new topic tool after the rest of the existing ones',
	'VIEWTOPIC_TOPIC_TOOLS_BEFORE'					=> 'Add a new topic tool before the rest of the existing ones',

	'ATTACHMENT_FILE_AFTER'							=> 'Add content after the attachment',
	'ATTACHMENT_FILE_APPEND'						=> 'Add custom attachment types displaying to the bottom of attachment block',
	'ATTACHMENT_FILE_BEFORE'						=> 'Add content before the attachment',
	'ATTACHMENT_FILE_PREPEND'						=> 'Add custom attachment types displaying to the top of attachment block',
	'FORUMLIST_BODY_CATEGORY_HEADER_ROW_APPEND'		=> 'Add content after the header row of the category on the forum list',
	'FORUMLIST_BODY_CATEGORY_HEADER_ROW_PREPEND'	=> 'Add content before the header row of the category on the forum list',
	'MCP_FORUM_TOPIC_TITLE_BEFORE'					=> 'Add some information before the topic title',
	'MCP_FORUM_TOPIC_TITLE_AFTER'					=> 'Add some information after the topic title',
	'MCP_POST_ADDITIONAL_OPTIONS_HTML'					=> 'Add content within the list of post moderation actions',
	'MCP_TOPIC_OPTIONS_AFTER'						=> 'Add some options (field, checkbox, ...) after the subject field when split a subject',
	'MCP_TOPIC_OPTIONS_BEFORE'						=> 'Add some options (field, checkbox, ...) before the subject field when split a subject',
	'MCP_TOPIC_TOPIC_TITLE_AFTER'					=> 'Add some information after the topic title',
	'MCP_TOPIC_TOPIC_TITLE_BEFORE'					=> 'Add some information before the topic title',
	'MEMBERLIST_BODY_RANK_APPEND'					=> 'Add information after rank in memberlist. Works in all display modes (leader, group and normal memberlist)',
	'MEMBERLIST_BODY_RANK_PREPEND'					=> 'Add information before rank in memberlist. Works in all display modes (leader, group and normal memberlist)',
	'MEMBERLIST_VIEW_RANK_AFTER'					=> 'Add information after rank in memberlist',
	'MEMBERLIST_VIEW_RANK_AVATAR_AFTER'				=> 'Add information after rank in memberlist (with avatar)',
	'MEMBERLIST_VIEW_RANK_AVATAR_BEFORE'			=> 'Add information before rank in memberlist (with avatar)',
	'MEMBERLIST_VIEW_RANK_BEFORE'					=> 'Add information after rank in memberlist',
	'MEMBERLIST_VIEW_RANK_NO_AVATAR_AFTER'			=> 'Add information after rank in memberlist (without avatar)',
	'MEMBERLIST_VIEW_RANK_NO_AVATAR_BEFORE'			=> 'Add information before rank in memberlist (without avatar)',
	'OVERALL_HEADER_FEEDS'							=> 'Add custom feeds',
	'OVERALL_HEADER_NAVBAR_BEFORE'					=> 'Add content before the navigation bar',
	'OVERALL_HEADER_SEARCHBOX_BEFORE'				=> 'Add content before the search box in the header',
	'POSTING_EDITOR_ADD_PANEL_TAB'					=> 'Add custom panel to post editor',
	'POSTING_EDITOR_BBCODE_STATUS_AFTER'			=> 'Add content after bbcode status',
	'POSTING_EDITOR_SMILIES_AFTER'					=> 'Add content after smilies',
	'POSTING_EDITOR_SMILIES_BEFORE'					=> 'Add content before the smilies',
	'POSTING_EDITOR_SUBMIT_BUTTONS'					=> 'Add custom buttons in the posting editor',
	'POSTING_LAYOUT_INCLUDE_PANEL_BODY'				=> 'Add include of custom panel template body in posting editor',
	'POSTING_PM_LAYOUT_INCLUDE_PM_HEADER_AFTER'		=> 'Add content after the include of posting_pm_header.html',
	'POSTING_PM_LAYOUT_INCLUDE_PM_HEADER_BEFORE'	=> 'Add content before the include of posting_pm_header.html',
	'POSTING_POLL_BODY_OPTIONS_AFTER'				=> 'Add content after the poll options on creating a poll',
	'POSTING_TOPIC_TITLE_AFTER'						=> 'Add content after the poll preview block',
	'QUICKREPLY_EDITOR_SUBJECT_BEFORE'				=> 'Add content before the quick reply subject textbox',
	'SEARCH_BODY_FORM_AFTER'						=> 'Add content after the search form',
	'SEARCH_BODY_FORM_BEFORE'						=> 'Add content before the search form',
	'SEARCH_BODY_RECENT_SEARCH_AFTER'				=> 'Add content after the recent search queries list',
	'SEARCH_BODY_RECENT_SEARCH_BEFORE'				=> 'Add content before the recent search queries list',
	'SEARCH_BODY_SEARCH_DISPLAY_OPTIONS_APPEND'		=> 'Put content at the bottom of the search query display options fields set',
	'SEARCH_BODY_SEARCH_DISPLAY_OPTIONS_PREPEND'	=> 'Put content at the top of the search query display options fields set',
	'SEARCH_BODY_SEARCH_OPTIONS_AFTER'				=> 'Add content after the search query options fields set',
	'SEARCH_BODY_SEARCH_OPTIONS_APPEND'				=> 'Put content at the bottom of the search query options fields set',
	'SEARCH_BODY_SEARCH_OPTIONS_BEFORE'				=> 'Add content before the search query options fields set',
	'SEARCH_BODY_SEARCH_OPTIONS_PREPEND'			=> 'Put content at the top of the search query options fields set',
	'SEARCH_BODY_SEARCH_QUERY_AFTER'				=> 'Add content after the search query fields set',
	'SEARCH_BODY_SEARCH_QUERY_APPEND'				=> 'Put content at the bottom of the search query fields set',
	'SEARCH_BODY_SEARCH_QUERY_BEFORE'				=> 'Add content before the search query fields set',
	'SEARCH_BODY_SEARCH_QUERY_PREPEND'				=> 'Put content at the top of the search query fields set',
	'SEARCH_RESULTS_HEADER_AFTER'					=> 'Add content after the header of the search results',
	'SEARCH_RESULTS_HEADER_BEFORE'					=> 'Add content before the header of the search results',
	'SEARCH_RESULTS_SEARCHBOX_AFTER'				=> 'Add content right after the searchbox of the search results',
	'UCP_MAIN_FRONT_USER_ACTIVITY_AFTER'			=> 'Add content right after the user activity info viewing UCP front page',
	'UCP_MAIN_FRONT_USER_ACTIVITY_BEFORE'			=> 'Add content right before the user activity info viewing UCP front page',
	'UCP_PM_HISTORY_POST_BUTTONS_AFTER'				=> 'Add post button to private messages in history review (next to quote etc), at the end of the list',
	'UCP_PM_HISTORY_POST_BUTTONS_BEFORE'			=> 'Add post button to private messages in history review (next to quote etc), at the start of the list',
	'UCP_PM_HISTORY_POST_BUTTONS_LIST_AFTER'		=> 'Add post button custom list to private messages in history review (next to quote etc), after the original list',
	'UCP_PM_HISTORY_POST_BUTTONS_LIST_BEFORE'		=> 'Add post button custom list to private messages in history review (next to quote etc), before the original list',
	'UCP_PM_HISTORY_REVIEW_AFTER'					=> 'Add content after the private messages history review',
	'UCP_PM_HISTORY_REVIEW_BEFORE'					=> 'Add content before the private messages history review',
	'UCP_PM_VIEWMESSAGE_POST_BUTTONS_LIST_AFTER'	=> 'Add post button custom list to private messages (next to edit, quote etc), after the original list',
	'UCP_PM_VIEWMESSAGE_POST_BUTTONS_LIST_BEFORE'	=> 'Add post button custom list to private messages (next to edit, quote etc), before the original list',
	'UCP_PM_VIEWMESSAGE_RANK_AFTER'					=> 'Add data after the rank on the user profile when viewing a private message',
	'UCP_PM_VIEWMESSAGE_RANK_BEFORE'				=> 'Add data before the rank on the user profile when viewing a private message',
	'UCP_PROFILE_PROFILE_INFO_BEFORE'				=> 'Add options in profile page fieldset - before jabber field',
	'UCP_PROFILE_PROFILE_INFO_AFTER'				=> 'Add options in profile page fieldset - after custom profile fields',
	'UCP_PROFILE_REGISTER_DETAILS_BEFORE'			=> 'Add options in profile page fieldset - before first field',
	'UCP_PROFILE_REGISTER_DETAILS_AFTER'			=> 'Add options in profile page fieldset - after confirm password field',
	'VIEWFORUM_BODY_TOPIC_ROW_AFTER'				=> 'Add content after the topic list item',
	'VIEWFORUM_BODY_TOPIC_ROW_APPEND'				=> 'Add content at the start of the topic list item',
	'VIEWFORUM_BODY_TOPIC_ROW_BEFORE'				=> 'Add content before the topic list item',
	'VIEWFORUM_BODY_TOPIC_ROW_PREPEND'				=> 'Add content at the end of the topic list item',
	'VIEWTOPIC_DROPDOWN_BOTTOM_CUSTOM'				=> 'Create a custom dropdown menu',
	'VIEWTOPIC_DROPDOWN_TOP_CUSTOM'					=> 'Create a custom dropdown menu',
	'VIEWFORUM_FORUM_TITLE_AFTER'					=> 'Add content directly after the forum title on the View forum screen',
	'VIEWFORUM_FORUM_TITLE_BEFORE'					=> 'Add content directly before the forum title on the View forum screen',
	'VIEWTOPIC_BODY_PAGINATION_TOP_AFTER'			=> 'Add content after the pagination at top',
	'VIEWTOPIC_BODY_POLL_AFTER'						=> 'Add content after the poll panel',
	'VIEWTOPIC_BODY_POLL_BEFORE'					=> 'Add content before the poll panel',
	'VIEWTOPIC_BODY_POST_BUTTONS_LIST_AFTER'		=> 'Add post button custom list to posts (next to edit, quote etc), after the original list',
	'VIEWTOPIC_BODY_POST_BUTTONS_LIST_BEFORE'		=> 'Add post button custom list to posts (next to edit, quote etc), before the original list',
	'VIEWTOPIC_BODY_POST_SUBJECT_BEFORE'			=> 'Add data before post icon and subject',
	'VIEWTOPIC_BODY_POSTROW_BACK2TOP_AFTER'			=> 'Add content to the post\'s bottom after the back to top link',
	'VIEWTOPIC_BODY_POSTROW_BACK2TOP_APPEND'		=> 'Add content to the post\'s bottom directly after the back to top link',
	'VIEWTOPIC_BODY_POSTROW_BACK2TOP_BEFORE'		=> 'Add content to the post\'s bottom before the back to top link',
	'VIEWTOPIC_BODY_POSTROW_BACK2TOP_PREPEND'		=> 'Add content to the post\'s bottom directly before the back to top link',
	'VIEWTOPIC_BODY_POSTROW_RANK_AFTER'				=> 'Add data after the rank on the user profile when viewing a post',
	'VIEWTOPIC_BODY_POSTROW_RANK_BEFORE'			=> 'Add data before the rank on the user profile when viewing a post',
	'VIEWTOPIC_TOPIC_TITLE_AFTER'					=> 'Add content directly after the topic title link on the View topic screen (outside of the h2 HTML tag)',
	'POSTING_PREVIEW_POLL_AFTER'					=> 'Add content after the poll preview block',
	'POSTING_TOPIC_TITLE_BEFORE'					=> 'Allows to add some information on the left of the topic title in the posting form',

	// ACP Template Events
	'ACP_BBCODES_ACTIONS_APPEND'					=> 'Add actions to the BBCodes page, after edit/delete buttons',
	'ACP_BBCODES_ACTIONS_PREPEND'					=> 'Add actions to the BBCodes page, before edit/delete buttons',
	'ACP_BBCODES_EDIT_FIELDSETS_AFTER'				=> 'Add settings to BBCode add/edit form',
	'ACP_EMAIL_OPTIONS_AFTER'						=> 'Add settings to mass email form',
	'ACP_FORUMS_MAIN_SETTINGS_APPEND'				=> 'Add settings to forums at end of main settings section',
	'ACP_FORUMS_MAIN_SETTINGS_PREPEND'				=> 'Add settings to forums before main settings section',
	'ACP_FORUMS_NORMAL_SETTINGS_APPEND'				=> 'Add settings to forums at end of normal settings section',
	'ACP_FORUMS_NORMAL_SETTINGS_PREPEND'			=> 'Add settings to forums before normal settings section',
	'ACP_FORUMS_PRUNE_SETTINGS_APPEND'				=> 'Add settings to forums at end of prune settings section',
	'ACP_FORUMS_PRUNE_SETTINGS_PREPEND'				=> 'Add settings to forums before prune settings section',
	'ACP_FORUMS_RULES_SETTINGS_APPEND'				=> 'Add settings to forums at end of rules settings section',
	'ACP_FORUMS_RULES_SETTINGS_PREPEND'				=> 'Add settings to forums before rules settings section',
	'ACP_GROUP_OPTIONS_BEFORE'						=> 'Add addtional options to group settings (before GROUP_FOUNDER_MANAGE)',
	'ACP_GROUP_OPTIONS_AFTER'						=> 'Add addtional options to group settings (after GROUP_RECEIVE_PM)',
	'ACP_MAIN_ACTIONS_APPEND'						=> 'Add actions to the ACP main page below the cache purge action',
	'ACP_MAIN_NOTICE_AFTER'							=> 'Add notices or other blocks in the ACP below other configuration notices',
	'ACP_OVERALL_FOOTER_AFTER'						=> 'Add content below the footer in the ACP',
	'ACP_OVERALL_HEADER_BODY_BEFORE'				=> 'Add content to the header body',
	'ACP_OVERALL_HEADER_HEAD_APPEND'				=> 'Add assets within the `&lt;head&gt;` tags in the ACP',
	'ACP_OVERALL_HEADER_STYLESHEETS_AFTER'			=> 'Add assets after stylesheets within the `&lt;head&gt;` tags in the ACP. Note that INCLUDECSS will not work with this event.',
	'ACP_POSTING_BUTTONS_AFTER'						=> 'Add content after BBCode posting buttons in the ACP',
	'ACP_POSTING_BUTTONS_BEFORE'					=> 'Add content before BBCode posting buttons in the ACP',
	'ACP_RANKS_EDIT_AFTER'							=> 'Add content after the rank details when editing a rank in the ACP',
	'ACP_RANKS_EDIT_BEFORE'							=> 'Add content before the rank details when editing a rank in the ACP',
	'ACP_RANKS_LIST_COLUMN_AFTER'					=> 'Add content before the first column in the ranks list in the ACP',
	'ACP_RANKS_LIST_COLUMN_BEFORE'					=> 'Add content after the last column (but before the action column) in the ranks list in the ACP',
	'ACP_RANKS_LIST_HEADER_AFTER'					=> 'Add content before the first header-column in the ranks list in the ACP',
	'ACP_RANKS_LIST_HEADER_BEFORE'					=> 'Add content after the last header-column (but before the action column) in the ranks list in the ACP',
	'ACP_SIMPLE_FOOTER_AFTER'						=> 'Add content below the simple footer in the ACP',
	'ACP_SIMPLE_HEADER_BODY_BEFORE'					=> 'Add content to the header body',
	'ACP_SIMPLE_HEADER_HEAD_APPEND'					=> 'Add assets within the `&lt;head&gt;` tags in the simple header of the ACP',
	'ACP_SIMPLE_HEADER_STYLESHEETS_AFTER'			=> 'Add assets after stylesheets within the `&lt;head&gt;` tags in the simple header of the ACP. Note that INCLUDECSS will not work with this event.',
	'ACP_USERS_OVERVIEW_OPTIONS_APPEND'				=> 'Add options and settings on user overview page',
	'ACP_USERS_PREFS_APPEND'						=> 'Add user options fieldset to the bottom of ACP users prefs settings',
	'ACP_USERS_PREFS_PREPEND'						=> 'Add user options fieldset to the top of ACP users prefs settings',
	'ACP_USERS_PREFS_PERSONAL_APPEND'				=> 'Add user options fieldset to the bottom of ACP users personal prefs settings',
	'ACP_USERS_PREFS_PERSONAL_PREPEND'				=> 'Add user options fieldset to the top of ACP users personal prefs settings',
	'ACP_USERS_PREFS_POST_APPEND'					=> 'Add user options fieldset to the bottom of ACP users post prefs settings',
	'ACP_USERS_PREFS_POST_PREPEND'					=> 'Add user options fieldset to the top of ACP users post prefs settings',
	'ACP_USERS_PREFS_VIEW_APPEND'					=> 'Add user options fieldset to the bottom of ACP users view prefs settings',
	'ACP_USERS_PREFS_VIEW_PREPEND'					=> 'Add user options fieldset to the top of ACP users view prefs settings',
	'ACP_BAN_CELL_APPEND'							=> 'Add content at the end of the ban cell area',
	'ACP_BAN_CELL_PREPEND'							=> 'Add content at the start of the ban cell area',
	'ACP_EMAIL_GROUP_OPTIONS_APPEND'				=> 'Add content at the end of the group options select box',
	'ACP_EMAIL_GROUP_OPTIONS_PREPEND'				=> 'Add content at the start of the group options select box',
	'ACP_EMAIL_FIND_USERNAME_APPEND'				=> 'Add content at the end of the find username link',
	'ACP_EMAIL_FIND_USERNAME_PREPEND'				=> 'Add content at the start of the find username link',
	'ACP_FORUMS_CUSTOM_SETTINGS'					=> 'Add its own box (&lt;fieldset&gt;) for extension settings',
	'ACP_FORUMS_QUICK_SELECT_BUTTON_APPEND'			=> 'Add content after the quick select forum submit button',
	'ACP_FORUMS_QUICK_SELECT_BUTTON_PREPEND'		=> 'Add content before the quick select forum submit button',
	'ACP_GROUPS_FIND_USERNAME_APPEND'				=> 'Add content at the end of the find username link',
	'ACP_GROUPS_FIND_USERNAME_PREPEND'				=> 'Add content at the start of the find username link',
	'ACP_GROUPS_MANAGE_AFTER'						=> 'Add content after the manage groups table',
	'ACP_GROUPS_MANAGE_BEFORE'						=> 'Add content before the manage groups table',
	'ACP_GROUPS_POSITION_LEGEND_ADD_BUTTON_AFTER'	=> 'Add content after adding group to legend submit button',
	'ACP_GROUPS_POSITION_LEGEND_ADD_BUTTON_BEFORE'	=> 'Add content before adding group to legend submit button',
	'ACP_GROUPS_POSITION_TEAMPAGE_ADD_BUTTON_AFTER'	=> 'Add content after adding group to teampage submit button',
	'ACP_GROUPS_POSITION_TEAMPAGE_ADD_BUTTON_BEFORE'=> 'Add content before adding group to teampage submit button',
	'ACP_LOGS_QUICK_SELECT_FORUM_BUTTON_APPEND'		=> 'Add content after the quick forum select form submit button',
	'ACP_LOGS_QUICK_SELECT_FORUM_BUTTON_PREPEND'	=> 'Add content before the quick forum select form submit button',
	'ACP_PERMISSION_FORUM_COPY_SRC_FORUM_APPEND'	=> 'Add content after the sourse forum select form',
	'ACP_PERMISSION_FORUM_COPY_SRC_FORUM_PREPEND'	=> 'Add content before the sourse forum select form',
	'ACP_PERMISSION_FORUM_COPY_DEST_FORUM_APPEND'	=> 'Add content after the destiny forum select form',
	'ACP_PERMISSION_FORUM_COPY_DEST_FORUM_PREPEND'	=> 'Add content before the destiny forum select form',
	'ACP_PERMISSIONS_ADD_GROUP_OPTIONS_APPEND'		=> 'Add content after the group multiple select form',
	'ACP_PERMISSIONS_ADD_GROUP_OPTIONS_PREPEND'		=> 'Add content before the group multiple select form',
	'ACP_PERMISSIONS_FIND_USERNAME_APPEND'			=> 'Add content after the find username link',
	'ACP_PERMISSIONS_FIND_USERNAME_PREPEND'			=> 'Add content before the find username link',
	'ACP_PERMISSIONS_SELECT_FORUM_APPEND'			=> 'Add content after the forum select form label',
	'ACP_PERMISSIONS_SELECT_FORUM_PREPEND'			=> 'Add content before the forum select form label',
	'ACP_PERMISSIONS_SELECT_GROUP_AFTER'			=> 'Add content after the group select form in usergroup view',
	'ACP_PERMISSIONS_SELECT_GROUP_APPEND'			=> 'Add content after the group select form label',
	'ACP_PERMISSIONS_SELECT_GROUP_BEFORE'			=> 'Add content before the group select form in usergroup view',
	'ACP_PERMISSIONS_SELECT_GROUP_PREPEND'			=> 'Add content before the group select form label',
	'ACP_PERMISSIONS_SELECT_MULTIPLE_FORUM_APPEND'	=> 'Add content after the forum multiple select form label',
	'ACP_PERMISSIONS_SELECT_MULTIPLE_FORUM_PREPEND'	=> 'Add content before the forum multiple select form label',
	'ACP_PROFILE_CONTACT_BEFORE'					=> 'Add extra options to custom profile field configuration in the ACP',
	'ACP_PRUNE_FORUMS_APPEND'						=> 'Add content after the forum select form label',
	'ACP_PRUNE_FORUMS_PREPEND'						=> 'Add content before the forum select form label',
	'ACP_PRUNE_USERS_FIND_USERNAME_APPEND'			=> 'Add content after the find username link',
	'ACP_PRUNE_USERS_FIND_USERNAME_PREPEND'			=> 'Add content before the find username link',
	'ACP_STYLES_LIST_BEFORE'						=> 'Add content before list of styles',
	'ACP_USERS_PROFILE_BEFORE'						=> 'Add content before the profile details when editing a user in the ACP',
	'ACP_USERS_PROFILE_AFTER'						=> 'Add content after the profile details but before the custom profile fields when editing a user in the ACP',
	'ACP_USERS_PROFILE_CUSTOM_AFTER'				=> 'Add content after the the custom profile fields when editing a user in the ACP',
	'ACP_USERS_SELECT_GROUP_AFTER'					=> 'Add content after group select form',
	'ACP_USERS_SELECT_GROUP_BEFORE'					=> 'Add content before group select form',
));
