<?php
/////////////////////////////////////////////////////
//                                                 //
//                 PHPPageProtect                  //
//                    V 1.0.0                      //
//                                                 //
//                 Copyright 2002                  //
//                  David Broker                   //
//            http://php.warpedweb.net/            //
//              All Rights Reserved                //
//                                                 //
//          In using this script you               //
//           agree to the following:               //
//                                                 //
//      This script may be used and modified       //
//              freely as long as this             //
//             copyright remains intact.           //
//                                                 //
//     You may not distibute this script, or       //
//           any modifications of it.              //
//                                                 //
//   A link must be provided on the website that   //
//             uses the script to:                 //
//          http://php.warpedweb.net/              //
//                                                 //
//      Any breaches of these conditions           //
//        will result in legal action.             //
//                                                 //
//      This script is distributed with            //
//        no warrenty, free of charge.             //
//                                                 //
/////////////////////////////////////////////////////

// Variables

// Path to the config file.

$config = "conf.php";

// End Variables

// Load config file.

require($config);

// Initial File checks to make sure the files exist before using them.

if(!file_exists($user_data)) {
 echo "<h1 align=\"center\">$user_data_file_not_exist</h1>";
 exit;
}
elseif(!is_readable($user_data)) {
 echo "<h1 align=\"center\">$user_data_file_not_readable</h1>";
 exit;
}
elseif($log_login) {
 if(!file_exists($log_file)) {
  echo "<h1 align=\"center\">$log_file_not_exist</h1>";
  exit;
 }
 elseif(!is_writable($log_file)) { 
  echo "<h1 align=\"center\">$log_file_not_writable</h1>";
  exit;
 }
}

// Perform operation according to command:

switch ($cmd) {
    case "login":
       if(check_user($username, $password, $name, $log_login)) {
              session_start("pageprotect");
              session_register('valid');
              session_register('username');
              session_register('name');
              // Uses MD5 and soundex to encode "valid" var to avoid easy access.
              $valid = strrev(soundex(name).md5($username));
              if ($log_login) {
                   $fd = @fopen($log_file, "a");
                   fputs($fd, time()."|$name|$username\n");
                   fclose($fd);
               }
               header("Location: $first_page?".SID);
               exit;

       } else {
         header("location: $login_page?cmd=invalid");
         exit;
       }
       break;
    case "unauth":
     session_start("pageprotect");
     session_destroy();
     print_header();
     echo "<h3 align=\"center\">$unauthorised</i></h3>";
     print_login();
     print_footer();
     break;
    case "invalid":
     print_header();
     echo "<h3 align=\"center\">$invalid_username_password</i></h3>";
     print_login($username);
     print_footer();
     break;
    case "logout":
     session_start("pageprotect");
     session_destroy();
     print_header();
     echo "<h3 align=\"center\">$logged_out</i></h3>";
     print_login($username);
     print_footer();
     break;
    default:
     print_header();
     print_login($username);
     print_footer();
     break;
}

function print_header() {
 // Prints the header of the page.
 echo "<html><head><title>Login</title></head><body style=\"font-family:arial;\">";
}

function print_footer() {
 // Prints the footer of the page.
echo "<div align=\"center\">
<br><font size=\"+1\"><b>PHPPageProtect</b></font>
<br>A script by <a href=\"http://php.warpedweb.net/\">David Broker</a>
<br><a href=\"http://php.warpedweb.net/\"><i>http://php.warpedweb.net/</i></a>
<br>Version $GLOBALS[version]</div></body></html>";
}

function check_user($username, $password, &$name, &$log) {
 // Checks to see the user is valid.
 if(($username == $GLOBALS[admin_username]) && ($password == $GLOBALS[admin_password])) {
  $name = "Administrator";
  $log = false;
  return true;
 }
 else {
  $file = @file($GLOBALS[user_data]);
  $pw = md5($password);
  $valid = false;
  if(is_array($file)) {
   foreach($file as $user) {
    $dat = explode("|", $user);
    if($username==$dat[0] && $pw == trim($dat[2])) {
     $valid = true;
     $name = $dat[1];
    }
   }
  }
  return $valid;
 }
}

function print_login($username='') {
 // Prints the login form.
echo "<h2 align=\"center\"><i>$GLOBALS[user_login]</i></h2>
<form method=\"post\" action=\"$GLOBALS[SCRIPT_NAME]\">
<input type=\"hidden\" name=\"cmd\" value=\"login\">
<table align=\"center\">
<tr><td>Username:</td><td><input type=\"text\" name=\"username\" value=\"$username\"></td></tr>
<tr><td>Password:</td><td><input type=\"password\" name=\"password\"></td></tr>
<tr><td colspan=\"2\" align=\"center\"><input type=\"submit\" value=\"Login\"></td></tr></table></form>";
}

?>