<?php
/*
This file is part of miniBB. miniBB is free discussion forums/message board software, without any warranty. See COPYING file for more details. Copyright (C) 2004-2007 Paul Puzyrev, Sergei Larionov. www.minibb.net
Latest File Update: 2007-May-15
*/

$GLOBALS['imgsWidth']=150; //static width for shrinking images

function enCodeBB($msg,$admin) {

$pattern=array(); $replacement=array();

$userUrlsAllowed=($GLOBALS['allowHyperlinks']==0 or $GLOBALS['user_id']==1 or ($GLOBALS['user_id']>1 and isset($GLOBALS['user_num_posts']) and $GLOBALS['user_num_posts']>=$GLOBALS['allowHyperlinks']));

$pattern[]="/\[nourl\](.+?)\[\/nourl\]/i";
$replacement[]="<!-- nourl -->\\1<!-- /nourl -->";

$pattern[]="/\[url[=]?\](.+?)\[\/url\]/i";
if($userUrlsAllowed) $replacement[]="<a href=\"\\1\" target=\"_blank\" rel=\"nofollow\">\\1</a>";
else $replacement[]="\\1";

$pattern[]="/\[url=((f|ht)tp[s]?:\/\/[^<> \n\r\[\]]+?)\](.*?)\[\/url\]/i";
if($userUrlsAllowed) $replacement[]="<a href=\"\\1\" target=\"_blank\" rel=\"nofollow\">\\3</a>";
else $replacement[]="\\1";

/* [IMGS] tag code - with fixed width */
$pattern[]="/\[imgs\](http:\/\/([^<> \n\r\[\]&]+?)\.?(gif|jpg|jpeg|png)?)\[\/imgs\]/i";
$replacement[]='<a href="\\1" target="_blank" rel="nofollow"><img src="\\1" alt="" title="" style="width:'.$GLOBALS['imgsWidth'].'px" /></a>';

/* [IMGS] tag code - with fixed width and ALT */
$pattern[]="/\[imgs=(http:\/\/([^<> \n\r\[\]&]+?)\.?(gif|jpg|jpeg|png)?)\](.*?)\[\/imgs\]/i";
$replacement[]='<a href="\\1" target="_blank" rel="nofollow"><img src="\\1" alt="\\4" title="\\4" style="width:'.$GLOBALS['imgsWidth'].'px" /></a>';

/* Old [IMG] tag code - without fixed width. */
$pattern[]="/\[img\](http:\/\/([^<> \n\r\[\]&]+?)\.?(gif|jpg|jpeg|png)?)\[\/img\]/i";
$replacement[]='<img src="\\1" alt="" title="" />';

/* Old [IMG] tag code - without fixed width, with alt. */
$pattern[]="/\[img=(http:\/\/([^<> \n\r\[\]&]+?)\.?(gif|jpg|jpeg|png)?)\](.*?)\[\/img\]/i";
$replacement[]='<img src="\\1" alt="\\4" title="\\4" />';

$pattern[]="/\[[bB]\](.+?)\[\/[bB]\]/s";
$replacement[]='<strong>\\1</strong>';

$pattern[]="/\[[iI]\](.+?)\[\/[iI]\]/s";
$replacement[]='<em>\\1</em>';

$pattern[]="/\[[uU]\](.+?)\[\/[uU]\]/s";
$replacement[]='<u>\\1</u>';

$pattern[]="/\[align(left|right|center)](.+?)\[\/align\]/is";
$replacement[]='<div style=\"text-align:\\1\">\\2</div>';

if($admin==1) {

$pattern[]="/\[font(#[A-F0-9]{6})\](.+?)\[\/font\]/is";
$replacement[]='<span style="color:\\1">\\2</span>';

}

if($admin==1 or $GLOBALS['isMod']==1){

$pattern[]="/\[urlc=((f|ht)tp[s]?:\/\/[^<> \n\r\[\]]+?)\](.*?)\[\/url\]/i";
$replacement[]="<a href=\"\\1\" target=\"_blank\">\\3</a>";

}

$msg=preg_replace($pattern, $replacement, $msg);

if(substr_count($msg,'<img')>0) $msg=str_replace('align=""', '', $msg);
if(substr_count($msg,'"nofollow"></a>')>0) $msg=str_replace('"nofollow"></a>', '"nofollow">URL</a>', $msg);

return $msg;
}

//--------------->
function deCodeBB($msg) {

$pattern=array(); $replacement=array();

$pattern[]="/<!-- nourl -->([^<> \n\r]+?)<!-- \/nourl -->/i";
$replacement[]="[nourl]\\1[/nourl]";

/* New [IMGs] tag code - with fixed width */ 
$pattern[]="/<a href=\"([^<> \n\r\[\]&]+?)\" target=\"_blank\" rel=\"nofollow\">[ ]<img src=\"([^<> \n\r\[\]]+?)\" alt=\"\" (title=\"\" )?style=\"width:[0-9]+px\" \/><\/a>/i";
$replacement[]="[imgs]\\1[/imgs]";

/* [IMGS] tag code - with fixed width and alt */ 
$pattern[]="/<a href=\"([^<> \n\r\[\]&]+?)\" target=\"_blank\"( rel=\"nofollow\")?>[ ]<img src=\"([^<> \n\r\[\]]+?)\" alt=\"(.+?)\" (title=\"(.+?)\" )?style=\"width:[0-9]+px\" \/><\/a>/i";
$replacement[]="[imgs=\\1]\\4[/imgs]";

/* Old [IMG] tag code - without fixed width. */
$pattern[]="/<img src=\"([^<> \n\r\[\]&]+?)\" alt=\"\" (title=\"\" )?\/>/i";
$replacement[]="[img]\\1[/img]";

/* [IMG] tag code - without fixed width, with alt. */
$pattern[]="/<img src=\"([^<> \n\r\[\]&]+?)\" alt=\"(.+?)\" (title=\"(.+?)\" )?\/>/i";
$replacement[]="[img=\\1]\\2[/img]";

$pattern[]="/<a href=\"([^<> \n\r\[\]]+?)\" target=\"(_new|_blank)\" rel=\"nofollow\">(.+?)<\/a>/i";
$replacement[]="[url=\\1]\\3[/url]";

if($GLOBALS['user_id']==1 or (isset($GLOBALS['isMod']) and $GLOBALS['isMod']==1)){
$pattern[]="/<a href=\"([^<> \n\r\[\]]+?)\" target=\"(_new|_blank)\">(.+?)<\/a>/i";
$replacement[]="[urlc=\\1]\\3[/url]";
}
else{
$pattern[]="/<a href=\"([^<> \n\r\[\]]+?)\" target=\"(_new|_blank)\">(.+?)<\/a>/i";
$replacement[]="[url=\\1]\\3[/url]";
}

$pattern[]="/<strong>(.+?)<\/strong>/is";
$replacement[]="[b]\\1[/b]";

$pattern[]="/<em>(.+?)<\/em>/is";
$replacement[]="[i]\\1[/i]";

$pattern[]="/<[uU]>(.+?)<\/[uU]>/s";
$replacement[]="[u]\\1[/u]";

$pattern[]="/<span style=\"color:(#[A-F0-9]{6})\">(.+?)<\/span>/is";
$replacement[]='[font\\1]\\2[/font]';

$pattern[]="/<div style=\"text-align:(left|right|center)\">(.+?)<\/div>/is";
$replacement[]='[align\\1]\\2[/align]';

$msg=preg_replace($pattern, $replacement, $msg);
$msg=str_replace ('<br />', "\n", $msg);
if(substr_count($msg, '[img\\2]')>0) $msg=str_replace('[img\\2]', '[img]', $msg);

if(function_exists('smileThis')) $msg=smileThis(FALSE,TRUE,$msg);

return $msg;
}

?>