--
-- таблица ALLIANCE_USER
--
CREATE TABLE IF NOT EXISTS `alliance_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) NOT NULL,
  `s_kem` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица ALLIANCE_PRIGLAS
--
CREATE TABLE IF NOT EXISTS `alliance_priglas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `kogo` int(11) NOT NULL,
  `priglas_up` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица ALLIANCE_DIPLOM
--
CREATE TABLE IF NOT EXISTS `alliance_diplom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `diplom_up` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица BUILD
--
CREATE TABLE IF NOT EXISTS `build` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `tip` int(11) NOT NULL,
  `lvl` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  `bonus` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=23 ;

INSERT INTO `build` (`id`, `name`, `tip`, `lvl`, `kol`, `bonus`, `cena`) VALUES 
(1, 'Военные склады', 1, 0, 0, 5, 10),
(2, 'Оружейный завод', 1, 25, 0, 20, 50),
(3, 'Ракетный завод', 1, 50, 0, 80, 100),
(4, 'Электростанция', 1, 75, 0, 300, 200),
(5, 'Нефтяные вышки', 1, 100, 0, 1300, 500),
(6, 'Исследовательская лаборатория', 1, 125, 0, 2500, 1000),
(7, 'Испытательный полигон', 1, 150, 0, 5100, 2400),
(8, 'Спутниковая сеть', 1, 175, 0, 10000, 5000),
(9, 'Термоядерный реактор', 1, 200, 0, 21000, 15000),
(10, 'Бункер', 2, 1, 0, 3, 250),
(11, 'Дозорная башня', 2, 34, 0, 10, 750),
(12, 'Система ПВО', 2, 67, 0, 15, 1280),
(13, 'Защитная батарея', 2, 100, 0, 32, 2540),
(14, 'Минное поле', 2, 133, 0, 50, 5130),
(15, 'Система "Страж"', 2, 166, 0, 75, 10200),
(16, 'Береговая оборона', 2, 199, 0, 90, 20000),
(17, 'Бараки', 3, 2, 0, 1, 2500),
(18, 'Авиабаза', 3, 41, 0, 2, 15000),
(19, 'Штаб связи', 3, 80, 0, 3, 50000),
(20, 'Военно-морская база', 3, 119, 0, 4, 200000),
(21, 'Лаборатория биоинженерии', 3, 158, 0, 5, 1500000),
(22, 'Генератор антиматерии', 3, 197, 0, 6, 5000000);

--
-- таблица ALLIANCE_PRIGLAS
--
CREATE TABLE IF NOT EXISTS `chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `time` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `date` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `tip` varchar(3) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица KONTRABANDA
--
CREATE TABLE IF NOT EXISTS `kontrabanda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `opisanie` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `result` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `shans` int(11) NOT NULL,
  `shans2` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

INSERT INTO `kontrabanda` (`id`, `name`, `opisanie`, `result`, `shans`, `shans2`, `cena`) VALUES 
(1, 'Чемодан', 'Дешево и сердито. С таким чемоданчиком не стыдно в люди выйти, но и похвастаться особо нечем.', '25% шанс заполучить секретную разработку!', 25, 0, 25),
(2, 'Ящик', 'Это уже товар по-серьезней. Среди денег и разноцветных таблеток попадаются и ключи от разной техники.', '50% шанс заполучить секретную разработку!', 50, 0, 50),
(3, 'Контейнер', 'Если по нему постучать, сразу становится понятно, что он таит в себе много приятных сюрпризов.', '100% шанс заполучить секретную разработку!', 100, 0, 100),
(4, 'Ангар', 'Раз уж контрабандить, то по-крупному. В ангар влезает все - от табельной рогатки до баллистической ракеты.', '100% секретная разработка + вторая с шансом 50%!', 100, 50, 150);

--
-- таблица LABORATORY
--
CREATE TABLE IF NOT EXISTS `laboratory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `opisanie` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

INSERT INTO `laboratory` (`id`, `name`, `opisanie`) VALUES 
(1, 'Энергетики', 'Восстановление энергии вдвое быстрее.'),
(2, 'Стимуляторы', 'Восстановление зарядов вдвое быстрее.'),
(3, 'Омоложение', 'Опыт не начисляется. Вы остаетесь на том же уровне.'),
(4, 'Стероиды', 'Вы получаете на 30% больше опыта за любое действие.'),
(5, 'Озверин', 'Увеличение навыка жестокости на 50 очков.'),
(6, 'Вазелин', 'Увеличение навыка ловкости на 50 очков.');

--
-- таблица MAIL
--
CREATE TABLE IF NOT EXISTS `mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) NOT NULL,
  `komu` int(11) NOT NULL,
  `date` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `time` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `text` varchar(1500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица MAIL_DIALOG
--
CREATE TABLE IF NOT EXISTS `mail_dialog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_dialog` int(11) NOT NULL,
  `status` int(1) NOT NULL,
  `status2` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица MAIL_IGNOR
--
CREATE TABLE IF NOT EXISTS `mail_ignor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_ignor` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица MAIL_KONTAKT
--
CREATE TABLE IF NOT EXISTS `mail_kontakt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_kontakt` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица MISSION
--
CREATE TABLE IF NOT EXISTS `mission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `id_operation` int(11) NOT NULL,
  `exp_mission` int(11) NOT NULL,
  `alliance` int(11) NOT NULL,
  `id_unit` int(11) NOT NULL,
  `kol_unit` int(11) NOT NULL,
  `exp_priz` int(11) NOT NULL,
  `baks_priz` int(11) NOT NULL,
  `lvl` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=51 ;

INSERT INTO `mission` (`id`, `name`, `id_operation`, `exp_mission`, `alliance`, `id_unit`, `kol_unit`, `exp_priz`, `baks_priz`, `lvl`) VALUES 
(1, 'Сходить в дозор', 1, 10, 1, 1, 1, 1, 100, 0),
(2, 'Выявить засаду врага', 1, 11, 2, 41, 1, 2, 110, 2),
(3, 'Укрепить свои позиции', 1, 12, 3, 80, 1, 3, 120, 4),
(4, 'Обучить войска', 1, 13, 4, 2, 1, 4, 130, 6),
(5, 'Обнаружить лагерь противника', 1, 14, 5, 42, 1, 5, 140, 8),
(6, 'Организовать засаду', 1, 15, 6, 81, 1, 6, 150, 10),
(7, 'Патрулировать береговую линию', 1, 16, 7, 3, 1, 7, 160, 12),
(8, 'Взять пленных', 1, 17, 8, 43, 1, 8, 170, 14),
(9, 'Уничтожить склады противника', 1, 18, 9, 82, 1, 9, 180, 16),
(10, 'Захватить базу противника', 1, 19, 10, 4, 1, 10, 190, 18),
(11, 'Установить военный лагерь', 2, 20, 11, 44, 2, 11, 200, 15),
(12, 'Отразить авиаатаку', 2, 21, 12, 83, 2, 12, 210, 17),
(13, 'Обнаружить вражеские корабли', 2, 22, 13, 5, 2, 13, 220, 19),
(14, 'Переправить войска', 2, 23, 14, 45, 2, 14, 230, 21),
(15, 'Захватить вражескую авиабазу', 2, 24, 15, 84, 2, 15, 240, 23),
(16, 'Получить превосходство в воздухе', 2, 25, 16, 6, 2, 16, 250, 25),
(17, 'Разбомбить позиции врага', 2, 26, 17, 46, 2, 17, 260, 27),
(18, 'Расследовать крушение вертолета', 2, 27, 18, 85, 2, 18, 270, 29),
(19, 'Десантироваться в тылу противника', 2, 28, 19, 7, 2, 19, 280, 31),
(20, 'Освободить заложников', 2, 29, 20, 47, 2, 20, 290, 33),
(21, 'Сопроводить подкрепление союзников', 3, 30, 21, 8, 3, 21, 300, 30),
(22, 'Разминировать территорию', 3, 31, 22, 48, 3, 22, 310, 32),
(23, 'Захватить оружейный склад', 3, 32, 23, 86, 3, 23, 320, 34),
(24, 'Уничтожить нефтезавод', 3, 33, 24, 9, 3, 24, 330, 36),
(25, 'Потопить вражеский танкер', 3, 34, 25, 49, 3, 25, 340, 38),
(26, 'Установить глубинные мины в море', 3, 35, 26, 87, 3, 26, 350, 40),
(27, 'Отрезать пути отступления', 3, 36, 27, 10, 3, 27, 360, 42),
(28, 'Захватить радиопередатчик', 3, 37, 28, 50, 3, 28, 370, 44),
(29, 'Уничтожить вражеские укрепления', 3, 38, 29, 88, 3, 29, 380, 46),
(30, 'Захватить нефтяные вышки', 3, 39, 30, 11, 3, 30, 390, 48),
(31, 'Прикрыть наступление союзника', 4, 40, 31, 51, 4, 21, 400, 45),
(32, 'Отбить контратаку', 4, 41, 32, 89, 4, 22, 410, 47),
(33, 'Блокировать транспортировку грузов', 4, 42, 33, 12, 4, 23, 420, 49),
(34, 'Защитить прибывающие корабли', 4, 43, 34, 52, 4, 24, 430, 51),
(35, 'Разведать расположение врага', 4, 44, 35, 90, 4, 25, 440, 53),
(36, 'Уничтожить установки ПВО', 4, 45, 36, 13, 4, 26, 450, 55),
(37, 'Захватить вражеские истребители', 4, 46, 37, 53, 4, 27, 460, 57),
(38, 'Бомбардировать оружейный завод', 4, 47, 38, 91, 4, 28, 470, 59),
(39, 'Осадить вражеский город', 4, 48, 39, 14, 4, 29, 480, 61),
(40, 'Уничтожить штаб противника', 4, 49, 40, 54, 4, 30, 490, 63),
(41, 'Отбить атаку с воздуха', 5, 50, 41, 15, 5, 31, 500, 60),
(42, 'Организовать засаду в джунглях', 5, 51, 42, 55, 5, 32, 510, 62),
(43, 'Уничтожить бронетехнику противника', 5, 52, 43, 92, 5, 33, 520, 64),
(44, 'Перехватить вражеские переговоры', 5, 53, 44, 16, 5, 34, 530, 66),
(45, 'Организовать противовоздушную оборону', 5, 54, 45, 56, 5, 35, 540, 68),
(46, 'Прикрыть наступление союзников', 5, 55, 46, 93, 5, 36, 550, 70),
(47, 'Разминировать подступы к городу', 5, 56, 47, 17, 5, 37, 560, 72),
(48, 'Прорвать защиту противника', 5, 57, 48, 57, 5, 38, 570, 74),
(49, 'Разведать местоположение врага', 5, 58, 49, 94, 5, 39, 580, 76),
(50, 'Предотвратить запуск ракет', 5, 59, 50, 18, 5, 40, 590, 78),
(51, 'Схватить вражеских шпионов', 6, 60, 51, 58, 6, 41, 600, 75),
(52, 'Отрезать пути к отступлению', 6, 61, 52, 95, 6, 42, 610, 77),
(53, 'Уничтожить вражеские подлодки', 6, 62, 53, 19, 6, 43, 620, 79),
(54, 'Эвакуировать местное население', 6, 63, 54, 59, 6, 44, 630, 81),
(55, 'Захватить пункты связи', 6, 64, 55, 96, 6, 45, 640, 83),
(56, 'Доставить боеприпасы', 6, 65, 56, 20, 6, 46, 650, 85),
(57, 'Уничтожить военный завод', 6, 66, 57, 60, 6, 47, 660, 87),
(58, 'Проникнуть на территорию врага', 6, 67, 58, 97, 6, 48, 670, 89),
(59, 'Усилить оборону территории', 6, 68, 59, 21, 6, 49, 680, 91),
(60, 'Уничтожить систему ПРО', 6, 69, 60, 61, 6, 50, 690, 93),
(61, 'Разведать дислокацию флота', 7, 70, 61, 98, 7, 51, 700, 90),
(62, 'Потопить вражеские подлодки', 7, 71, 62, 22, 7, 52, 710, 92),
(63, 'Уничтожить порт', 7, 72, 63, 62, 7, 53, 720, 94),
(64, 'Совершить налет на авианосец', 7, 73, 64, 99, 7, 54, 730, 96),
(65, 'Десантировать войска', 7, 74, 65, 23, 7, 55, 740, 98),
(66, 'Наладить снабжение', 7, 75, 66, 63, 7, 56, 750, 100),
(67, 'Уничтожить систему радиолокации', 7, 76, 67, 100, 7, 57, 760, 102),
(68, 'Защитить авиабазу', 7, 77, 68, 24, 7, 58, 770, 104),
(69, 'Организовать поддержку с воздуха', 7, 78, 69, 64, 7, 59, 780, 106),
(70, 'Уничтожить вражескую лабораторию', 7, 79, 70, 101, 7, 60, 790, 108),
(71, 'Захватить порт', 8, 80, 71, 25, 8, 61, 800, 105),
(72, 'Укрепить позиции', 8, 81, 72, 65, 8, 62, 810, 107),
(73, 'Провести спасательную операцию', 8, 82, 73, 102, 8, 63, 820, 109),
(74, 'Захватить транспортер противника', 8, 83, 74, 26, 8, 64, 830, 111),
(75, 'Взять в плен вражеского ученого', 8, 84, 75, 66, 8, 65, 840, 113),
(76, 'Узнать дислокацию секретного завода', 8, 85, 76, 103, 8, 66, 850, 115),
(77, 'Отвлечь подводные лодки', 8, 86, 77, 27, 8, 67, 860, 117),
(78, 'Уничтожить линию электропередачи', 8, 87, 78, 67, 8, 68, 870, 119),
(79, 'Установить подводные мины', 8, 88, 79, 104, 8, 69, 880, 121),
(80, 'Уничтожить завод биооружия', 8, 89, 80, 28, 8, 70, 890, 123),
(81, 'Установить патрули в городе', 9, 90, 81, 68, 9, 71, 900, 120),
(82, 'Освободить заложников', 9, 91, 82, 105, 9, 72, 910, 122),
(83, 'Уничтожить штаб террористов', 9, 92, 83, 29, 9, 73, 920, 124),
(84, 'Провести диверсионную операцию', 9, 93, 84, 69, 9, 74, 930, 126),
(85, 'Взорвать склад с боеприпасами', 9, 94, 85, 106, 9, 75, 940, 128),
(86, 'Захватить пути сообщения', 9, 95, 86, 30, 9, 76, 950, 130),
(87, 'Встретить подкрепление', 9, 96, 87, 70, 9, 77, 960, 132),
(88, 'Организовать осаду города', 9, 97, 88, 107, 9, 78, 970, 134),
(89, 'Отбить атаку врага', 9, 98, 89, 31, 9, 79, 980, 136),
(90, 'Захватить город', 9, 99, 90, 71, 9, 80, 990, 138),
(91, 'Захватить порт', 10, 100, 91, 108, 10, 81, 1000, 135),
(92, 'Выявить засаду врага', 10, 101, 92, 32, 10, 82, 1010, 137),
(93, 'Патрулировать береговую линию', 10, 102, 93, 72, 10, 83, 1020, 139),
(94, 'Захватить базу противника', 10, 103, 94, 109, 10, 84, 1030, 141),
(95, 'Сопроводить подкрепление союзников', 10, 104, 95, 33, 10, 85, 1040, 143),
(96, 'Разминировать территорию', 10, 105, 96, 74, 10, 86, 1050, 145),
(97, 'Отрезать пути отступления', 10, 106, 97, 110, 10, 87, 1060, 147),
(98, 'Захватить нефтяные вышки', 10, 107, 98, 34, 10, 88, 1070, 149),
(99, 'Отбить атаку с воздуха', 10, 108, 99, 75, 10, 89, 1080, 152),
(100, 'Уничтожить бронетехнику противника', 10, 109, 100, 111, 10, 90, 1090, 153);

--
-- таблица NAEMNIKI
--
CREATE TABLE IF NOT EXISTS `naemniki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `opisanie` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `chto_daet` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `naemniki` (`id`, `name`, `opisanie`, `chto_daet`) VALUES 
(1, 'Генерал Армстронг', 'Нет другого рода войск, кроме наземных. А если даже и есть, то он быстро исправит этот недостаток. Беспощаден, жесток, неустрашим, а все почему? А потому, что в танке.', '+20% к атаке и защите всех наземных войск.'),
(2, 'Адмирал Дрейк', 'Его родина – солнечная Сомали. Сам он утверждает, что сын пирата и русалки. Психиатры же говорят об обратном. Во всем руководствуется приказами попугая. При виде его море начинает укачивать.', '+20% к атаке и защите флота.'),
(3, 'Чёрный ястреб', 'Человек, который сбил самолетов больше, чем у него волос на фюзеляже. Свою первую воздушную цель уничтожил в 4 года, играя в аэропорту с воздушным змеем. Рожденный летать. Ползать не умеет.', '+20% к атаке и защите авиации.'),
(4, 'Контрагент Смит', 'Ходячая смерть для любого шпиона. Выявляет предателя с одного удара монтировкой. Мастерски хранит тайны. Умеет молчать на 67 языках мира.', 'Скрывает ваш профиль от противников.'),
(5, 'Лара Иванова', 'Прекрасный специалист по охмурению наемников. Никто не в силах оторвать взгляд от ее больших, упругих, необъятных… глаз.', 'Выводит из строя вражеских наемников. Не действует, если присутствует у обеих сторон.');

--
-- таблица NEWS
--
CREATE TABLE IF NOT EXISTS `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `time` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `avtor` int(11) NOT NULL,
  `tema` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `text` varchar(10000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `status` int(1) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица OFCLUB_ARMRESTLING
--
CREATE TABLE IF NOT EXISTS `ofclub_armrestling` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user_1` int(11) NOT NULL,
  `id_user_2` int(11) NOT NULL,
  `user_1_do` int(11) NOT NULL,
  `user_2_do` int(11) NOT NULL,
  `user_1_time_up` int(11) NOT NULL,
  `user_2_time_up` int(11) NOT NULL,
  `start_time_up` int(11) NOT NULL,
  `start_1` int(1) NOT NULL,
  `start_2` int(1) NOT NULL,
  `rezult_1` int(1) NOT NULL,
  `rezult_2` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица OFCLUB_DOPROS
--
CREATE TABLE IF NOT EXISTS `ofclub_dopros` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `start` int(1) NOT NULL,
  `kol` int(1) NOT NULL DEFAULT '5',
  `bal` int(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица OFCLUB_VETERAN
--
CREATE TABLE IF NOT EXISTS `ofclub_veteran` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_viner` int(11) NOT NULL,
  `chislo` int(9) NOT NULL,
  `old_chislo` int(9) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `ofclub_veteran` (`id`, `id_viner`, `chislo`, `old_chislo`) VALUES 
(1, 1, 555555555, 111111111);

--
-- таблица OPERATION
--
CREATE TABLE IF NOT EXISTS `operation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `exp` int(11) NOT NULL,
  `lvl` int(11) NOT NULL,
  `rang` int(11) NOT NULL,
  `point` int(11) NOT NULL DEFAULT '3',
  `id_trof` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

INSERT INTO `operation` (`id`, `name`, `exp`, `lvl`, `rang`, `point`, `id_trof`) VALUES 
(1, 'Шапка Мономаха', 290, 0, 1, 1, 6),
(2, 'Изгнание из Прайда', 490, 15, 1, 1, 1),
(3, 'Медвежья Берлога', 690, 30, 1, 1, 4),
(4, '1000 и 1 ночь', 890, 45, 1, 1, 3),
(5, 'Свидание с Амазонкой', 1090, 60, 1, 1, 2),
(6, 'Молот Тора', 1290, 75, 1, 1, 5),
(7, 'Охота на Ягуара', 1490, 90, 1, 1, 7),
(8, 'Тасманийский Дьявол', 1690, 105, 1, 1, 8),
(9, 'Дух Прерий', 1890, 120, 1, 1, 9),
(10, 'Снежная Королева', 2090, 135, 1, 1, 0);

--
-- таблица SANCTION
--
CREATE TABLE IF NOT EXISTS `sanction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) NOT NULL,
  `kogo` int(11) NOT NULL,
  `data` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `time_up` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `nagrada` int(11) NOT NULL,
  `stavka` int(11) NOT NULL DEFAULT '100',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица START
--
CREATE TABLE IF NOT EXISTS `start` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case` int(2) NOT NULL,
  `text` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

INSERT INTO `start` (`id`, `case`, `text`) VALUES 
(1, 0, 'Солдат, ты прибыл как раз вовремя! Мы продвигаемся к позициям врага! Не теряй ни секунды - атакуй противника!'),
(2, 1, 'Прекрасный выстрел! Ты подбил вражеский танк! Молодец! Продолжай атаку!'),
(3, 2, 'Великолепно! Враг отступил и в спешке бросил несколько единиц техники, которая тебе может понадобится в будущем. Возьми себе ее на вооружение в разделе "Техника".'),
(4, 3, 'Бери вон тот истребитель и вперед, на поле боя. Впереди наша главная цель - вражеская база!'),
(5, 4, 'Заходи с фланга, а мы тебя прикроем! В атаку!!!'),
(6, 5, 'Враг ведет обстрел из огневой точки. Постарайся ее уничтожить!'),
(7, 6, 'Прямо в цель! Молодец! Победа уже практически у нас в кармане. Добивай этих гадов!!!'),
(8, 7, 'Поздравляю тебя, солдат! Ты сыграл главную роль в этой битве, поэтому я доверяю тебе поднять флаг над базой!'),
(9, 8, 'Теперь, когда база наша, нужно позаботиться о безопасности. Выполни миссию "Сходить в дозор".'),
(10, 9, 'Половина дела сделано. Выполни спецоперацию еще раз чтобы завершить ее.'),
(11, 10, 'Выбери себе портрет!'),
(12, 11, 'Ты неплохо справляешься! Дальше ты будешь действовать самостоятельно - базу я отдаю тебе в распоряжение. Если у тебя будут какие-то вопросы, ты всегда сможешь найти меня в разделе "Миссии". Удачи!');

--
-- таблица STRANA
--
CREATE TABLE IF NOT EXISTS `strana` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `index` varchar(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `opisanie` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `bonus` int(11) NOT NULL,
  `start_bonus` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

INSERT INTO `strana` (`id`, `name`, `index`, `opisanie`, `bonus`, `start_bonus`) VALUES 
(1, 'Россия', 'r', 'Вы – владыка морей. Бонус к силе военно-морского флота.', 20, 20),
(2, 'Германия', 'g', 'Дисциплина – Ваше второе имя. Бонус к силе наземных войск.', 20, 30),
(3, 'США', 'a', 'Небо - ваша стихия. Бонус к силе авиации.', 20, 30),
(4, 'Украина', 'u', 'Вы учитесь на ошибках, зарабатывая опыт быстрее всех.', 20, 30),
(5, 'Белоруссия', 'b', 'Благодаря мудрому руководству уровень жизни повышается.', 20, 10),
(6, 'Китай', 'c', 'Вы – промышленный гигант. Стоимость техники снижена.', 20, 30),
(7, 'Казахстан', 'k', 'Резко-континентальный климат дает Вам бонус к защите.', 20, 30);

--
-- таблица SUPERUNIT
--
CREATE TABLE IF NOT EXISTS `superunit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `kol` int(11) NOT NULL,
  `ataka` int(11) NOT NULL,
  `zaschita` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

INSERT INTO `superunit` (`id`, `name`, `kol`, `ataka`, `zaschita`) VALUES 
(1, 'Терминатор', 0, 5, 5),
(2, 'Цербер', 0, 10, 5),
(3, 'Тамерлан', 0, 15, 10),
(4, 'Весёлый Роджер', 0, 0, 10),
(5, 'Кракен', 0, 0, 15),
(6, 'Атлантида', 0, 5, 20),
(7, 'Гарпия', 0, 10, 0),
(8, 'Луч Теслы', 0, 15, 0),
(9, 'Тень', 0, 20, 10),
(10, 'Кузькина мать', 0, 100, 100);

--
-- таблица TROFEI
--
CREATE TABLE IF NOT EXISTS `trofei` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `status` INT(11) NOT NULL,
  `lvl` INT(2) NOT NULL,
  `cena_baks` INT(11) NOT NULL,
  `cena_gold` INT(11) NOT NULL,
  `time_up` INT(11) NOT NULL,
  `day` INT(11) NOT NULL,
  `bonus_1` INT(11) NOT NULL,
  `bonus_2` INT(11) NOT NULL,
  `next_1` INT(11) NOT NULL,
  `next_2` INT(11) NOT NULL,
  `shag_1` INT(11) NOT NULL,
  `shag_2` INT(11) NOT NULL,
  `opisanie_1` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `opisanie_2` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `opisanie_3` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `uslovie_1` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `uslovie_2` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `uslovie_3` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `uslovie_4` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

INSERT INTO `trofei` (`id`, `name`, `status`, `lvl`, `cena_baks`, `cena_gold`, `time_up`, `day`, `bonus_1`, `bonus_2`, `next_1`, `next_2`, `shag_1`, `shag_2`, `opisanie_1`, `opisanie_2`, `opisanie_3`, `uslovie_1`, `uslovie_2`, `uslovie_3`, `uslovie_4`) VALUES
(1, 'Инкассатор', 0, 1, 100000, 5, 0, 2, 1, 1, 2, 2, 1, 1, 'Уменьшает комиссию при вложении денег в хранилище', 'Уменьшает комиссию при вложении денег в хранилище на', 'а также уменьшает вероятность взлома вашего хранилища на', 'выполняйте "Изгнaние из прайда"', 'следующий уровень на', 'и', 'соответственно'),
(2, 'Самолёт снабжения', 0, 1, 100000, 5, 0, 2, 8, 1, 16, 2, 8, 1, 'Уменьшает время восстановления боеприпасов и дает шанс не использовать боеприпас при атаке', 'Уменьшает время восстановления боеприпасов на', 'а также не использовать его с шансом на', 'выполняйте "Свидание с амазонкой"', 'следующий уровень на', 'и', 'соответственно'),
(3, 'Полевая кухня', 0, 1, 100000, 5, 0, 2, 8, 1, 16, 2, 8, 1, 'Уменьшает время восстановления энергии, а также дает шанс не использовать ее', 'Уменьшает время восстановления энергии на', 'а также не потратить ее с шансом на', 'выполняйте "1000 и 1 ночь"', 'следующий уровень на', 'и', 'соответственно'),
(4, 'Рембригада', 0, 1, 100000, 5, 0, 2, 10, 0, 20, 0, 10, 0, 'Снижает расходы на технику', 'Снижает расходы на содержание техники на ', '', 'выполняйте "Медвежья Берлога"', 'следующий уровень на', '', ''),
(5, 'Дешифратор', 0, 1, 100000, 5, 0, 2, 10, 0, 20, 0, 10, 0, 'Увеличивает получаемый опыт', 'Увеличивает получаемый опыт на', '', 'выполняйте "Молот Тора"', 'следующий уровень на', '', ''),
(6, 'Медсанчасть', 0, 1, 100000, 5, 0, 2, 2, 2, 4, 4, 2, 2, 'Увеличивает максимальный уровень здоровья и дает шанс возврата денег за лечение', 'Увеличивает максимальный уровень здоровья на', 'а также возврат денег за лечение с шансом на', 'выполняйте "Шапка Мономаха"', 'следующий уровень на', 'и', 'соответственно'),
(7, 'Хищник', 0, 1, 100000, 5, 0, 2, 2, 0, 4, 0, 2, 0, 'Увеличивает атаку всей техники', 'Увеличивает атаку всей техники на', '', 'выполняйте "Тасманийский дьявол"', 'следующий уровень на', '', ''),
(8, 'Железный купол', 0, 1, 100000, 5, 0, 2, 2, 0, 4, 0, 2, 0, 'Увеличивает защиту всей техники', 'Увеличивает защиту всей техники на', '', 'выполняйте "Охота на ягуара"', 'следующий уровень на', '', ''),
(9, 'Алмазный бур', 0, 1, 100000, 5, 0, 2, 4, 0, 8, 0, 4, 0, 'Дает возможность при выполнении фаталити над противником ограбить его хранилище', 'Дает возможность при убийстве противника ограбить его хранилище с шансом на', '', 'выполняйте "Дух прерий"', 'следующий уровень на', '', ''),
(10, 'Адронный усилитель', 0, 1, 100000, 5, 0, 2, 15, 0, 30, 0, 15, 0, 'Значительно увеличивает атаку и защиту секретных разработок', 'Увеличивает атаку и защиту секретных разработок на', '', 'покупайте контрабанду', 'следующий уровень на', '', ''),
(11, 'Набор швеи', 0, 1, 100000, 5, 0, 2, 2, 2, 4, 4, 2, 2, 'Дает бонус к ловкости и аналогичный шанс, что если вам отрежут ухо, оно сразу же восстановится', 'Дает бонус к ловкости на', 'а также, если вам отрежут ухо, оно сразу же восстановится с шансом на', 'милуйте игроков', 'следующий уровень на', 'и', 'соответственно'),
(12, 'Электробритва "Киев"', 0, 1, 100000, 5, 0, 2, 2, 2, 4, 4, 2, 2, 'Дает бонус к жестокости, а также шанс, что при успешном фаталити Вы отрежете противнику оба уха, если они есть', 'Дает бонус к жестокости на', 'а также при успешном фаталити Вы отрежете противнику оба уха, если они есть с шансом на', 'совершайте фаталити', 'следующий уровень на', 'и', 'соответственно'),
(13, 'Знамя Победы', 0, 1, 100000, 5, 0, 2, 1, 0, 2, 0, 1, 0, 'Увеличивает бонус от каждого полученного подкрепления', 'Увеличивает бонус от каждого полученного подкрепления на', '', 'отправляйте подкрепления', 'следующий уровень на', '', ''),
(14, 'Растяжка', 0, 1, 100000, 5, 0, 2, 1, 0, 2, 0, 1, 0, 'Дает шанс, что враг при атаке наступит на мину. Если он подорвется, то потеряет все здоровье и соответствующее количество техники', 'Дает шанс, что враг при атаке наступит на мину. Если он подорвется, то потеряет все здоровье и соответствующее количество техники на', '', 'стройте минные поля', 'следующий уровень на', '', ''),
(15, 'Лицензия на убийство', 0, 1, 100000, 5, 0, 2, 4, 4, 8, 8, 4, 4, 'Увеличивает силу критического удара и дает такой же шанс, что Вы восстановите свое здоровье на 10% от нанесенного урона', 'Увеличивает силу критического удара на', 'и что Вы восстановите свое здоровье на 10% от нанесенного урона с шансом на', 'убивайте других игроков', 'следующий уровень на', 'и', 'соответственно'),
(16, 'Баночка йода', 0, 1, 100000, 5, 0, 2, 4, 4, 8, 8, 4, 4, 'Увеличивает силу лечения в групповых боях (легионе)', 'Увеличивает силу лечения в групповых боях (легионе) на', 'и шанс критического лечения на', 'лечите других игроков', 'следующий уровень на', 'и', 'соответственно'),
(17, 'Радар', 0, 1, 100000, 5, 0, 2, 5, 0, 10, 0, 5, 0, 'Экономит боеприпасы и энергию на прокачку лазера', 'Экономит боеприпасы и энергию на прокачку лазера на', '', 'успешно сбить ракету противника', 'следующий уровень на', '', ''),
(18, 'Система "Стэлс"', 0, 1, 100000, 5, 0, 2, 5, 0, 10, 0, 5, 0, 'Экономит боеприпасы и энергию на прокачку ракеты', 'Экономит боеприпасы и энергию на прокачку ракеты на', '', 'провести успешно ракетную атаку', 'следующий уровень на', '', '');

--
-- таблица UNIT
--
CREATE TABLE IF NOT EXISTS `unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `tip` int(11) NOT NULL,
  `lvl` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  `ataka` int(11) NOT NULL,
  `zaschita` int(11) NOT NULL,
  `soderzhanie` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=119 ;

INSERT INTO `unit` (`id`, `name`, `tip`, `lvl`, `kol`, `ataka`, `zaschita`, `soderzhanie`, `cena`) VALUES 
(1, 'Шквал', 1, 0, 0, 2, 2, 0, 30),
(2, 'Гвоздика', 1, 6, 0, 4, 2, 0, 50),
(3, 'Урал', 4, 9, 0, 140, 70, 0, 5),
(4, 'Sheridan', 1, 12, 0, 9, 6, 0, 180),
(5, 'Бережок', 1, 18, 0, 12, 10, 0, 350),
(6, 'Смерч', 1, 24, 0, 17, 11, 7, 650),
(7, 'Bradley', 1, 30, 0, 28, 16, 15, 1500),
(8, 'Sergeant York', 1, 36, 0, 16, 35, 25, 2500),
(9, 'Рысь', 1, 42, 0, 60, 12, 31, 5600),
(10, 'Гиацинт-С', 1, 48, 0, 42, 17, 38, 7400),
(11, 'Storm', 1, 54, 0, 19, 48, 49, 9000),
(12, 'Выстрел', 1, 60, 0, 45, 30, 70, 12000),
(13, 'Урал', 1, 66, 0, 36, 50, 110, 22000),
(14, 'HIMARS', 4, 69, 0, 210, 140, 0, 5),
(15, 'Аmtrack', 1, 72, 0, 46, 53, 160, 28000),
(16, 'Бук', 1, 78, 0, 54, 57, 210, 37000),
(17, 'Abrams', 1, 84, 0, 71, 49, 250, 45000),
(18, 'Росток', 1, 90, 0, 83, 57, 330, 57000),
(19, 'Leclerc', 1, 96, 0, 90, 60, 390, 70000),
(20, 'Тор', 1, 102, 0, 115, 50, 450, 85000),
(21, 'HIMARS', 1, 108, 0, 108, 72, 550, 103000),
(22, 'Leopard', 4, 111, 0, 280, 210, 0, 5),
(23, 'Armadillo', 1, 114, 0, 118, 74, 690, 130000),
(24, 'Буратино', 1, 120, 0, 125, 78, 840, 150000),
(25, 'Тунгуска', 1, 126, 0, 130, 82, 1080, 160000),
(26, 'Grizzly', 1, 132, 0, 140, 85, 1500, 180000),
(27, 'Leopard', 1, 138, 0, 143, 99, 1600, 190000),
(28, 'Мста-С', 4, 141, 0, 350, 280, 0, 5),
(29, 'Панцирь-С1', 1, 144, 0, 159, 96, 1700, 210000),
(30, 'Берег', 1, 150, 0, 143, 125, 1900, 230000),
(31, 'Владимир', 1, 156, 0, 161, 78, 1800, 240000),
(32, 'Тайфун', 1, 161, 0, 155, 136, 2000, 250000),
(33, 'Прометей', 1, 168, 0, 169, 128, 2200, 275000),
(34, 'Мста-С', 1, 173, 0, 180, 140, 2300, 290000),
(35, 'Тополь-М', 4, 177, 0, 420, 350, 0, 5),
(36, 'Merkava', 1, 180, 0, 200, 160, 2500, 300000),
(37, 'Гарпун', 1, 188, 0, 190, 170, 2600, 310000),
(38, 'Пеленг', 1, 194, 0, 220, 180, 2700, 320000),
(39, 'Valkirya', 1, 197, 0, 250, 210, 2800, 330000),
(40, 'Тополь-М', 1, 200, 0, 300, 250, 3000, 350000),
(41, 'Тарантул', 2, 1, 0, 2, 4, 0, 48),
(42, 'Зубр', 2, 7, 0, 2, 5, 0, 80),
(43, 'Knox', 2, 13, 0, 5, 9, 0, 200),
(44, 'Гранит', 5, 16, 0, 50, 100, 0, 5),
(45, 'Бдительный', 2, 19, 0, 8, 15, 0, 560),
(46, 'Носорог', 2, 25, 0, 11, 20, 14, 1120),
(47, 'Ерш', 2, 31, 0, 15, 25, 30, 2400),
(48, 'O.H. Perry', 2, 37, 0, 20, 45, 45, 4000),
(49, 'Лунь', 2, 43, 0, 30, 50, 80, 7360),
(50, 'Кречет', 2, 49, 0, 42, 57, 85, 8800),
(51, 'Молния', 2, 55, 0, 0, 55, 0, 4400),
(52, 'Орлан', 2, 61, 0, 45, 65, 172, 22400),
(53, 'Гранит', 2, 67, 0, 62, 71, 250, 30400),
(54, 'Zumwalt', 5, 70, 0, 100, 200, 0, 5),
(55, 'Arleigh Burke', 2, 73, 0, 50, 80, 330, 38400),
(56, 'Атлант', 2, 79, 0, 0, 101, 0, 16000),
(57, 'Акула', 2, 85, 0, 70, 90, 460, 55200),
(58, 'Ticonderoga', 2, 91, 0, 75, 97, 510, 66800),
(59, 'Аркан', 2, 97, 0, 95, 106, 580, 89600),
(60, 'Skjold', 2, 103, 0, 85, 112, 600, 107200),
(61, 'Mistral', 5, 106, 0, 150, 300, 0, 5),
(62, 'Zumwalt', 2, 109, 0, 110, 120, 700, 127200),
(63, 'Astute', 2, 115, 0, 95, 131, 1070, 153600),
(64, 'Дэринг', 2, 121, 0, 130, 140, 1300, 176000),
(65, 'Marjata', 2, 127, 0, 0, 139, 0, 72000),
(66, 'Хубэи', 2, 133, 0, 118, 148, 1800, 200000),
(67, 'Mistral', 2, 139, 0, 140, 150, 2100, 213600),
(68, 'Sea Shadow', 5, 142, 0, 200, 400, 0, 5),
(69, 'Огайо', 2, 145, 0, 120, 163, 2300, 240000),
(70, 'Мурена', 2, 151, 0, 124, 170, 2400, 256000),
(71, 'Protector', 2, 157, 0, 0, 200, 0, 96000),
(72, 'Swift', 2, 163, 0, 134, 190, 3000, 304000),
(73, 'Wasp', 2, 169, 0, 145, 196, 3200, 320000),
(74, 'Sea Shadow', 2, 175, 0, 156, 200, 3500, 352000),
(75, 'Barrakuda', 5, 178, 0, 350, 700, 0, 5),
(76, 'Посейдон', 2, 181, 0, 160, 220, 37000, 381000),
(77, 'Наутилус', 2, 187, 0, 168, 253, 38000, 401000),
(78, 'Kent', 2, 193, 0, 175, 265, 39000, 415000),
(79, 'Barrakuda', 2, 199, 0, 183, 280, 42000, 423000),
(80, 'Tiger II', 3, 2, 0, 7, 1, 0, 60),
(81, 'Flogger', 3, 8, 0, 10, 4, 0, 120),
(82, 'Harrier II', 6, 11, 0, 200, 50, 0, 5),
(83, 'Barrakuda', 3, 14, 0, 15, 5, 0, 280),
(84, 'Thunderbolt II', 3, 20, 0, 25, 5, 0, 640),
(85, 'Tomcat', 3, 26, 0, 45, 13, 35, 2800),
(86, 'Fulcrum', 3, 32, 0, 55, 2, 57, 5200),
(87, 'Apache', 3, 38, 0, 65, 15, 60, 8640),
(88, 'Foxhound', 3, 44, 0, 75, 6, 72, 12000),
(89, 'Грач', 3, 50, 0, 88, 30, 84, 13600),
(90, 'Flanker', 3, 56, 0, 110, 5, 130, 22400),
(91, 'Harrier II', 3, 62, 0, 117, 20, 230, 27600),
(92, 'Comanche', 6, 65, 0, 300, 100, 0, 5),
(93, 'Fighting Falcon', 3, 68, 0, 150, 0, 0, 9600),
(94, 'Backfire', 3, 74, 0, 142, 12, 360, 54400),
(95, 'Черная акула', 3, 80, 0, 150, 65, 460, 64000),
(96, 'Flanker-C', 3, 86, 0, 200, 0, 0, 28000),
(97, 'Eurofighter', 3, 92, 0, 160, 30, 650, 113600),
(98, 'Сокол', 3, 98, 0, 250, 0, 0, 44000),
(99, 'Comanche', 3, 104, 0, 182, 16, 800, 160000),
(100, 'Кобра', 6, 107, 0, 400, 150, 0, 5),
(101, 'Blackbird', 3, 110, 0, 198, 18, 1020, 180000),
(102, 'Night hawk', 3, 116, 0, 210, 70, 1560, 202400),
(103, 'Кобра', 3, 122, 0, 225, 22, 2100, 220000),
(104, 'Мрия', 3, 128, 0, 230, 140, 2700, 240000),
(105, 'Самсон', 6, 131, 0, 500, 200, 0, 5),
(106, 'Super Stallion', 3, 134, 0, 240, 65, 3000, 280000),
(107, 'Беркут', 3, 140, 0, 245, 78, 3300, 320000),
(108, 'Lightning II', 3, 146, 0, 253, 146, 37000, 368000),
(109, 'Spirit', 3, 152, 0, 260, 155, 40000, 384000),
(110, 'Чистилище', 3, 158, 0, 270, 112, 42000, 408000),
(111, 'Агнец', 3, 162, 0, 283, 120, 44000, 458000),
(112, 'Агнец', 6, 165, 0, 1000, 400, 0, 5),
(113, 'Фантом', 3, 168, 0, 300, 0, 0, 100000),
(114, 'Giena', 3, 174, 0, 294, 90, 46000, 500000),
(115, 'Vampir', 3, 182, 0, 300, 150, 48000, 530000),
(116, 'Шмель', 3, 186, 0, 315, 167, 50000, 570000),
(117, 'Dragon', 3, 192, 0, 330, 180, 52000, 630000),
(118, 'Самсон', 3, 198, 0, 350, 200, 55000, 700000);

--
-- таблица USER_BONUS
--
CREATE TABLE IF NOT EXISTS `user_bonus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `status_day` int(1) NOT NULL,
  `status_bonus` int(1) NOT NULL,
  `day` varchar(2) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `month` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `year` varchar(4) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

--
-- таблица USER_BUILD
--
CREATE TABLE IF NOT EXISTS `user_build` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_build` int(11) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `tip` int(11) NOT NULL,
  `lvl` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  `bonus` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица USER_FATALITI
--
CREATE TABLE IF NOT EXISTS `user_fataliti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `uho1_kto` int(11) NOT NULL,
  `uho2_kto` int(11) NOT NULL,
  `uho1_up` int(11) NOT NULL,
  `uho2_up` int(11) NOT NULL,
  `fataliti1` int(11) NOT NULL,
  `fataliti2` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица USER_LABORATORY
--
CREATE TABLE IF NOT EXISTS `user_laboratory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_lab` int(1) NOT NULL,
  `status` int(1) NOT NULL,
  `time_up` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица USER_MISSION
--
CREATE TABLE IF NOT EXISTS `user_mission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_operation` int(11) NOT NULL,
  `id_mission` int(11) NOT NULL,
  `name` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `exp_mission` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `max_exp` int(11) NOT NULL,
  `alliance` int(11) NOT NULL,
  `id_unit` int(11) NOT NULL,
  `kol_unit` int(11) NOT NULL,
  `exp_priz` int(11) NOT NULL,
  `baks_priz` int(11) NOT NULL,
  `lvl` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица USER_NAEMNIKI
--
CREATE TABLE IF NOT EXISTS `user_naemniki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_naemnik` int(1) NOT NULL,
  `status` int(1) NOT NULL,
  `time_up` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица USER_OPERATION
--
CREATE TABLE IF NOT EXISTS `user_operation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_operation` int(11) NOT NULL,
  `name` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `exp` int(11) NOT NULL,
  `lvl` int(11) NOT NULL,
  `max_exp` int(11) NOT NULL,
  `rang` int(11) NOT NULL,
  `point` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица USER_REG
--
CREATE TABLE IF NOT EXISTS `user_reg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(15) NOT NULL,
  `pass` varchar(32) NOT NULL,
  `email` varchar(50) NOT NULL,
  `ip` varchar(25) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `browser` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `referer` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `refer` int(11)  NOT NULL,
  `data_reg` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `time_reg` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `site` varchar(25) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

--
-- таблица USER_SET
--
CREATE TABLE IF NOT EXISTS `user_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sex` set('m','w') NOT NULL DEFAULT 'm',
  `side` set('r','g','a','u','b','c','k') NOT NULL DEFAULT 'r',
  `logo` varchar(3) NOT NULL DEFAULT 'on',
  `fon` varchar(8) NOT NULL DEFAULT 'standart',
  `prava` int(1)  NOT NULL,
  `ip_new` varchar(25) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `browser_new` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `last_date_visit` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `last_time_visit` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `mesto` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `start` int(2) NOT NULL,
  `online` int(11)  NOT NULL,
  `hp` int(11) NOT NULL DEFAULT '100',
  `mp` int(11) NOT NULL DEFAULT '100',
  `udar` int(11) NOT NULL DEFAULT '5',
  `max_hp` int(11) NOT NULL DEFAULT '100',
  `max_mp` int(11) NOT NULL DEFAULT '100',
  `max_udar` int(11) NOT NULL DEFAULT '5',
  `hp_up` int(11) NOT NULL,
  `mp_up` int(11) NOT NULL,
  `udar_up` int(11) NOT NULL,
  `skill` int(11)  NOT NULL,
  `exp` int(25)  NOT NULL,
  `lvl` int(3)  NOT NULL,
  `gold` int(33) NOT NULL DEFAULT '0',
  `baks` int(33) NOT NULL DEFAULT '0',
  `baks_hran` int(33) NOT NULL,
  `raiting` int(11) NOT NULL,
  `diplomat` int(11) NOT NULL DEFAULT '1',
  `diplomat_max` int(11) NOT NULL DEFAULT '1',
  `diplomat_cena` int(11) NOT NULL DEFAULT '25',
  `avatar` varchar(5) NOT NULL DEFAULT '0',
  `zvanie` varchar(25) NOT NULL DEFAULT 'Рядовой',
  `zheton` int(11)  NOT NULL,
  `uho` int(11)  NOT NULL,
  `wins` int(11) NOT NULL,
  `loses` int(11) NOT NULL,
  `kills` int(11) NOT NULL,
  `dies` int(11) NOT NULL,
  `build_up` int(11) NOT NULL,
  `dohod` int(11) NOT NULL,
  `soderzhanie` int(11) NOT NULL,
  `chistaya` int(11) NOT NULL,
  `build_energy` int(11) NOT NULL DEFAULT '1',
  `krit` int(11) NOT NULL,
  `uvorot` int(11) NOT NULL,
  `id_vrag` int(11) NOT NULL,
  `raiting_loses` int(11) NOT NULL,
  `raiting_wins` int(11) NOT NULL,
  `pomiloval` int(11) NOT NULL,
  `sanctions` int(11) NOT NULL,
  `sanction_status` int(1) NOT NULL,
  `donat_bonus` int(33) NOT NULL,
  `ofclub_veteran_time_up` int(11) NOT NULL,
  `ofclub_veteran_chislo` int(9) NOT NULL,
  `news` int(1) NOT NULL,
  `unit_hp` int(11) NOT NULL,
  `refer_gold` int(11) NOT NULL,
  `refer_baks` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

--
-- таблица USER_SUPERUNIT
--
CREATE TABLE IF NOT EXISTS `user_superunit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_unit` int(11) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `kol` int(11) NOT NULL,
  `ataka` int(11) NOT NULL,
  `zaschita` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица USER_TROFEI
--
CREATE TABLE IF NOT EXISTS `user_trofei` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `id_user` INT(11) NOT NULL,
  `id_trof` INT(11) NOT NULL,
  `status` INT(11) NOT NULL,
  `lvl` INT(2) NOT NULL,
  `cena_baks` INT(11) NOT NULL,
  `cena_gold` INT(11) NOT NULL,
  `time_up` INT(11) NOT NULL,
  `day` INT(11) NOT NULL,
  `bonus_1` INT(11) NOT NULL,
  `bonus_2` INT(11) NOT NULL,
  `next_1` INT(11) NOT NULL,
  `next_2` INT(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица USER_UNIT
--
CREATE TABLE IF NOT EXISTS `user_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_unit` int(11) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `tip` int(11) NOT NULL,
  `lvl` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  `ataka` int(11) NOT NULL,
  `zaschita` int(11) NOT NULL,
  `soderzhanie` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица VOINA_UNIT
--
CREATE TABLE IF NOT EXISTS `voina_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_unit` int(11) NOT NULL,
  `tip` int(1) NOT NULL,
  `ataka` int(11) NOT NULL,
  `zaschita` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица USER_VOINA
--
CREATE TABLE IF NOT EXISTS `user_voina` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_vrag` int(11) NOT NULL,
  `data` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `time` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `nanes` int(11) NOT NULL,
  `poluchil` int(11) NOT NULL,
  `baks` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `rezult` varchar(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- таблица WORLDKASSA
--
CREATE TABLE IF NOT EXISTS `worldkassa` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID платежа (Внутренний ID)',
  `id_user` int(11) unsigned NOT NULL COMMENT 'ID пользователя',
  `id_bill` int(11) unsigned NOT NULL COMMENT 'ID платежа в Worldkassa',
  `time` int(11) unsigned NOT NULL COMMENT 'Время инициализации платежа',
  `time_oplata` int(11) unsigned DEFAULT '0' COMMENT 'Время оплаты',
  `summa` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT 'Сумма',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Статистика платежей через WorldKassa' AUTO_INCREMENT=1 ;

--
-- таблица WORLDKASSA_SUMMA
--
CREATE TABLE IF NOT EXISTS `worldkassa_summa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `summa` int(11) NOT NULL,
  `opisanie` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `worldkassa_summa` (`id`, `summa`, `opisanie`) VALUES 
(1, 10, 'Горсть золота'),
(2, 50, 'Мешок золота'),
(3, 100, 'Ларец золота'),
(4, 500, 'Сундук золота'),
(5, 1000, 'Сокровище золота');
