<?php

// проверка наличия авторизации
if (isset($user))
{
    # Перенаправляем на главную
    header('Location: /');   
}

# Заголовок модуля
$system['page_title'] = 'Регистрация';

# Шапка модуля
require_once(HOME .'/incfiles/header.php');

// Обрабатываем запрос на регистрацию
if (isset($_POST['reg_submit']))
{
    # Логин
    $reg_login = txt($_POST['reg_login']);
    
    # Проверка ввода логина
    if (empty($reg_login)) $err .= 'Не введен логин<br />';    
    
    # Проверка длины логина
    if (!empty($reg_login) && (strlen($reg_login) < 3 || strlen($reg_login) > 32)) $err .= 'Неверная длина логина. Допустимо от 3 до 32 символов<br />';
    
    # Проверка занятости логина
    if (mysql_num_rows(mysql_query("SELECT * FROM `users` WHERE `login` = '". input($reg_login) ."'")) != 0) $err .= 'Логин ' . $reg_login . ' занят. Выберите другой<br />';            
    
    # Ник
    $reg_nick = txt($_POST['reg_nick']);
    
    # Проверка ввода ника
    if (empty($reg_nick)) $err .= 'Не введен ник<br />';    
    
    # Проверка длины логина
    if (!empty($reg_nick) && (strlen_rus($reg_nick) < 3 || strlen_rus($reg_nick) > 64)) $err .= 'Неверная длина ника. Допустимо от 3 до 64 символов<br />';
    
    # Проверка символов в логине
    if (!empty($reg_nick) && !preg_match("#^([A-zА-я0-9\-\_\ ])+$#ui", $reg_nick)) $err .= 'Запрещенные символы в нике. Разрешены символы A-zА-я0-9-_ и пробел.<br />';
    
    # Проверка занятости логина
    if (mysql_num_rows(mysql_query("SELECT * FROM `users` WHERE `nick` = '". input($reg_nick) ."'")) != 0) $err .= 'Ник ' . $reg_nick . ' занят. Выберите другой<br />';
    
    # Пароль
    $reg_password = txt($_POST['reg_password']);
    
    # Проверка ввода пароля
    if (empty($reg_password)) $err .= 'Не введен пароль<br />';
    
    # Проверка длины пароля
    if (!empty($reg_password) && (strlen($reg_password) < 5 || strlen($reg_password) > 64)) $err .= 'Неверная длина пароля. Допустимо от 5 до 64 символов<br />';
    
    # Повторный пароль    
    $reg_password2 = txt($_POST['reg_password2']);
    
    # Проверка ввода повторного пароля
    if (empty($reg_password2)) $err .= 'Не введен повторный пароль<br />';
    
    # Проверка совпадения паролей
    if (!empty($reg_password2) && $reg_password != $reg_password2) $err .= 'Пароли не совпадают<br />';
    
    # Проверочный код
    $reg_code = txt($_POST['reg_code']);
    
    # Проверка ввода проверочного кода
    if (empty($reg_code)) $err .= 'Не введен проверочный код<br />';
    
    # Проверка правильности кода
    if (!empty($reg_code) && $reg_code != $_SESSION['code']) $err .= 'Неверный проверочный код<br />';
    
    // Проводим регистрацию
    if (!isset($err))
    {
        # Кодируем пароль
        $reg_password = encrypt($reg_password);
        
        # Запрос на регистрацию
        mysql_query("INSERT INTO `users` SET `login` = '". input($reg_login) ."', `nick` = '". input($reg_nick) ."', `password` = '". input($reg_password) ."', `date_reg` = '". time() ."', `date_last_entry` = '". time() ."'");
        
        # Выводим уведомление
        echo '<div class="title">Завершение регистрации</div>
        <div class="menu">
        Регистрация на сайте успешно завершена. Вы можете войти на сайт под регистрационными данными или перейти ниже по ссылке быстрой авторизации.<br />
        <a href="/?login='. input($reg_login) .'&amp;password='. input($reg_password2) .'">Быстрая авторизация</a>
        </div>';
        
        # Ноги модуля
        require_once(HOME .'/incfiles/footer.php');
    }
}

error($err);

echo '<div class="title">Регистрация</div>
<form method="post" action="/user/registration.php">
<div class="menu">
Логин: (max 32)<br />
<input type="text" name="reg_login" value="'. output($_POST['reg_login']) .'" /><br />
<span class="small_info">* Только англ. символы. Используется только для входа. На сайте не отображается.</span><br />
Ник:<br />
<input type="text" name="reg_nick" value="'. output($_POST['reg_nick']) .'" /><br />
<span class="small_info">* Допустимы русские символы. Используется для отображения на сайте.</span><br />
Пароль: (max 64)<br />
<input type="password" name="reg_password" /><br />
Повторите пароль:<br />
<input type="password" name="reg_password2" /><br />
Введите код на картинке:<br />';
captcha();
echo '<input type="text" name="reg_code"><br />
<input type="submit" name="reg_submit" value="Регистрировать" />
</div>
</form>';

echo '<div class="block">
&raquo; <a href="/user/entry.php">Авторизация</a><br />
&raquo; <a href="/">На главную</a>
</div>';


# Ноги модуля
require_once(HOME .'/incfiles/footer.php');

?>
