<?php

/**
 * Управление модулями
 */

// Проверка прав доступа
if (!isset($user) || $user['admin_panel'] != 2) {
  # Возврат на главную страницу
  header('Location: /');  
}

// Только для уровня 14 и выше
if ($user['level'] < 14) {
  # Возврат на главную страницу
  header('Location: /');  
} 
 
# Заголовок модуля
$system['page_title'] = 'Управление модулями';

# Шапка модуля
require_once(HOME .'/incfiles/header.php');

# Вывод ошибок
error($err);

// Обработка запроса статуса загрзу-центра
if (isset($_POST['downloads'])) {
  # Статус модуля загруз-центра
  $downloads_module = num($_POST['downloads_module']);
  
  // Проверка корректности статуса
  if ($downloads_module != 1 && $downloads_module != 2) $err .= 'Неверный формат статуса загруз-центра.<br />';
  
  # Причина закрытия
  $downloads_module_about = txt($_POST['downloads_module_about']);
  
  // Если причина пуста
  if (empty($downloads_module_about)) $err .= 'Введите причину закрытия загруз-центра.<br />';
  
  // Если неверна длина причины
  if (!empty($downloads_module_about) && (strlen_rus($downloads_module_about) < 2 || strlen_rus($downloads_module_about) > 3000)) $err .= 'Неверная длина причины закрытия загруз-центра. Допустимо от 2 до 3000 символов.<br />';
  
  // Сохранение данных
  if (!isset($err)) {
    # Запрос на сохранение статуса
    mysql_query("UPDATE `system` SET `value` = '$downloads_module' WHERE `key` = 'downloads_module'");
    
    # Запрос на сохранение причины
    mysql_query("UPDATE `system` SET `value` = '". input($downloads_module_about) ."' WHERE `key` = 'downloads_module_about'");
    
    # Вывод уведомления
    echo '<div class="title">Сохранение настроек</div>
    <div class="menu">
    Настройки успешно сохранены.
    </div>';
    
    echo '<div class="block">
    &raquo; <a href="/admin/modules.php">Управление модулями</a><br />
    &raquo; <a href="/admin/">Панель управления</a><br />
    &raquo; <a href="/">На главную</a>
    </div>';
    
    # Ноги модуля
    require_once(HOME .'/incfiles/footer.php');          
  }
}

// Обработка запроса статуса форума
if (isset($_POST['forum'])) {
  # Статус модуля форума
  $forum_module = num($_POST['forum_module']);
  
  // Проверка корректности статуса
  if ($forum_module != 1 && $forum_module != 2) $err .= 'Неверный формат статуса форума.<br />';
  
  # Причина закрытия
  $forum_module_about = txt($_POST['forum_module_about']);
  
  // Если причина пуста
  if (empty($forum_module_about)) $err .= 'Введите причину закрытия форума.<br />';
  
  // Если неверна длина причины
  if (!empty($forum_module_about) && (strlen_rus($forum_module_about) < 2 || strlen_rus($forum_module_about) > 3000)) $err .= 'Неверная длина причины закрытия форума. Допустимо от 2 до 3000 символов.<br />';
  
  // Сохранение данных
  if (!isset($err)) {
    # Запрос на сохранение статуса
    mysql_query("UPDATE `system` SET `value` = '$forum_module' WHERE `key` = 'forum_module'");
    
    # Запрос на сохранение причины
    mysql_query("UPDATE `system` SET `value` = '". input($forum_module_about) ."' WHERE `key` = 'forumы_module_about'");
    
    # Вывод уведомления
    echo '<div class="title">Сохранение настроек</div>
    <div class="menu">
    Настройки успешно сохранены.
    </div>';
    
    echo '<div class="block">
    &raquo; <a href="/admin/modules.php">Управление модулями</a><br />
    &raquo; <a href="/admin/">Панель управления</a><br />
    &raquo; <a href="/">На главную</a>
    </div>';
    
    # Ноги модуля
    require_once(HOME .'/incfiles/footer.php');          
  }
}

echo '<div class="title">Управление модулями</div>
<form method="post" action="/admin/modules.php">
<div class="menu">
Загруз-центр:<br />
<select name="downloads_module" size="1">
<option value="1"'. ($system['downloads_module'] == 1?' selected="selected"':NULL) .'>Открыт</option>
<option value="2"'. ($system['downloads_module'] == 2?' selected="selected"':NULL) .'>Закрыт</option>
</select><br />
Причина закрытия:<br />
<textarea name="downloads_module_about" rows="4" cols="25">'. output($system['downloads_module_about']) .'</textarea><br />
<span class="small_info">* Отображается когда загруз-центр закрыт.</span><br />
<input type="submit" name="downloads" value="Сохранить" />
</div>

<div class="menu">
Форум:<br />
<select name="forum_module" size="1">
<option value="1"'. ($system['forum_module'] == 1?' selected="selected"':NULL) .'>Открыт</option>
<option value="2"'. ($system['forum_module'] == 2?' selected="selected"':NULL) .'>Закрыт</option>
</select><br />
Причина закрытия:<br />
<textarea name="forum_module_about" rows="4" cols="25">'. output($system['forum_module_about']) .'</textarea><br />
<span class="small_info">* Отображается когда форум закрыт.</span><br />
<input type="submit" name="forum" value="Сохранить" />
</div>
</form>';

echo '<div class="block">
&raquo; <a href="/admin/">Панель управления</a><br />
&raquo; <a href="/">На главную</a>
</div>';

# Ноги модуля
require_once(HOME .'/incfiles/footer.php');

?>
